/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.ApiArchiveEndpoint;
import de.ponton.api.websocket.ApiInboundEndpoint;
import de.ponton.api.websocket.ApiOutboundEndpoint;
import de.ponton.api.websocket.ApiServlet;
import de.ponton.api.websocket.SSLCertificateFactory;
import de.ponton.api.websocket.SpringEndpointFactory;
import de.ponton.api.websocket.WebSocketServerException;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.management.ManagementFactory;
import java.security.KeyStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ApiWebSocketServer {
    private static final int SIZE64KB = 65536;
    private static final int IDLE_TIMEOUT = 360000;
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ApiWebSocketServer");
    private final SpringEndpointFactory springEndpointFactory;
    private final SSLCertificateFactory certificateFactory;
    private final IServerConfigBean serverConfig;
    private int port;
    private String host;
    private Server server;

    public ApiWebSocketServer(SpringEndpointFactory springEndpointFactory, SSLCertificateFactory certificateFactory, IServerConfigBean serverConfig) {
        this.springEndpointFactory = springEndpointFactory;
        this.certificateFactory = certificateFactory;
        this.serverConfig = serverConfig;
    }

    public void startup() throws Exception {
        this.server = this.createServer();
        MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addBean((Object)mbeanContainer);
        try {
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)context);
            this.server.setHandler((Handler)stats);
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, container) -> {
                container.setDefaultMaxBinaryMessageBufferSize(65536);
                container.setDefaultMaxTextMessageBufferSize(65536);
                container.setDefaultMaxSessionIdleTimeout(360000L);
                ServerEndpointConfig inboundEndpoint = ServerEndpointConfig.Builder.create(ApiInboundEndpoint.class, (String)"/inbound").configurator((ServerEndpointConfig.Configurator)this.springEndpointFactory).build();
                container.addEndpoint(inboundEndpoint);
                ServerEndpointConfig outboundEndpoint = ServerEndpointConfig.Builder.create(ApiOutboundEndpoint.class, (String)"/outbound").configurator((ServerEndpointConfig.Configurator)this.springEndpointFactory).build();
                container.addEndpoint(outboundEndpoint);
                ServerEndpointConfig archiveEndpoint = ServerEndpointConfig.Builder.create(ApiArchiveEndpoint.class, (String)"/archive").configurator((ServerEndpointConfig.Configurator)this.springEndpointFactory).build();
                container.addEndpoint(archiveEndpoint);
                servletContext.addServlet("/", ApiServlet.class);
            });
            this.server.start();
            LOG.info("started Websocket server on {}:{}", (Object)this.host, (Object)this.port);
        }
        catch (Exception e) {
            LOG.error("could not start Websocket server on {}:{}", (Object)this.host, (Object)this.port, (Object)e);
            this.shutdown();
            throw e;
        }
    }

    private Server createServer() throws WebSocketServerException {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(false);
        threadPool.setName("WebsocketPort");
        Server server = new Server((ThreadPool)threadPool);
        server.setStopTimeout(1000L);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        this.port = this.serverConfig.getAdapterInterfacePort();
        ServerConnector serverConnector = this.createSecureConnector(server, httpFactory);
        serverConnector.setName("Secure WebSocket " + this.port);
        LOG.info("Created {}", (Object)serverConnector.getName());
        this.host = this.serverConfig.getAdapterInterfaceAddress();
        serverConnector.setPort(this.port);
        serverConnector.setIdleTimeout(360000L);
        Slf4jRequestLogWriter writer = new Slf4jRequestLogWriter();
        writer.setLoggerName("Messenger.HTTP");
        CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
        server.setRequestLog((RequestLog)requestLog);
        server.addConnector((Connector)serverConnector);
        return server;
    }

    private ServerConnector createSecureConnector(Server server, HttpConnectionFactory httpFactory) throws WebSocketServerException {
        KeyStore serverKeystore = this.certificateFactory.generateCertificate();
        SslContextFactory.Server factory = new SslContextFactory.Server();
        factory.setTrustAll(true);
        factory.setKeyStore(serverKeystore);
        factory.setSslSessionTimeout(360000);
        factory.setKeyManagerPassword("asKnj720spdrvmas_ornOj");
        factory.setRenegotiationAllowed(false);
        factory.addExcludeProtocols(new String[]{"SSLv2Hello", "SSLv3"});
        return new ServerConnector(server, factory, new ConnectionFactory[]{httpFactory});
    }

    public void shutdown() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.join();
                LOG.debug("Websocket service stopped");
            }
            catch (Exception e1) {
                LOG.error("could not stop Websocket service", (Throwable)e1);
            }
        }
    }
}

