/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.AbstractEndpoint;
import de.ponton.api.websocket.messages.ChallengeResponseHandler;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiInboundEndpoint
extends AbstractEndpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ApiInboundEndpoint");

    public ApiInboundEndpoint(ChallengeResponseHandler challengeResponseHandler) {
        super(challengeResponseHandler);
    }

    @Override
    public void onMessage(byte[] partialMessage, boolean last) {
        if (this.authenticated) {
            LOG.warn("ignoring unexpected binary data:{} last:{}", (Object)partialMessage, (Object)last);
        } else {
            super.onMessage(partialMessage, last);
        }
    }

    public void onMessage(String message) {
        block5: {
            block4: {
                if (!this.authenticated) break block4;
                SimpleProperties properties = this.convert(message);
                String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, "UNKNOWN");
                LOG.debug("received message {}", (Object)messageType);
                switch (ProtocolMessageTypeEnum.valueOf((String)messageType)) {
                    case InboundMessageStatusUpdate: 
                    case OutboundMessageStatusUpdateResponse: {
                        if (Objects.nonNull(this.expectResponse)) {
                            this.expectResponse.complete(properties);
                            break;
                        }
                        break block5;
                    }
                    default: {
                        this.closeSessionWithProtocolError("received not supported message type " + messageType);
                        break;
                    }
                }
                break block5;
            }
            this.closeUnauthenticatedSession();
        }
    }

    public boolean isOpen() {
        if (this.session == null) {
            return false;
        }
        return this.session.isOpen();
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        if (Objects.nonNull(this.expectResponse)) {
            LOG.trace("completing future due to closed websocket");
            this.expectResponse.completeExceptionally(new IOException("websocket was closed"));
        }
        super.onClose(session, closeReason);
    }
}

