/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.AbstractEndpoint;
import de.ponton.api.websocket.ApiCloseCodes;
import de.ponton.api.websocket.messages.ChallengeResponseHandler;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.WebSocketCloseCode;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiArchiveEndpoint
extends AbstractEndpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger((String)("Messenger." + ApiArchiveEndpoint.class.getSimpleName()));

    public ApiArchiveEndpoint(ChallengeResponseHandler challengeResponseHandler) {
        super(challengeResponseHandler);
    }

    public void onMessage(String message) {
        block7: {
            block6: {
                if (!this.authenticated) break block6;
                this.responseHeader = this.convert(message);
                String messageType = this.responseHeader.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, "UNKNOWN");
                LOG.debug("received message {}", (Object)messageType);
                switch (ProtocolMessageTypeEnum.valueOf((String)messageType)) {
                    case ArchiveStoreDataResponse: 
                    case ArchiveDeleteDataResponse: {
                        if (Objects.nonNull(this.expectResponse)) {
                            this.expectResponse.complete(this.responseHeader);
                            break;
                        }
                        break block7;
                    }
                    case ArchiveGetDataResponse: {
                        if (this.responseHeader.containsProperty(ArchivePropertiesEnum.ERROR_MESSAGE) && Objects.nonNull(this.expectResponse)) {
                            this.expectResponse.complete(this.responseHeader);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        this.closeSessionWithProtocolError("received not supported message type " + messageType);
                        break;
                    }
                }
                break block7;
            }
            this.closeUnauthenticatedSession();
        }
    }

    @Override
    public void onMessage(byte[] partialMessage, boolean last) {
        if (this.authenticated) {
            try {
                ((OutputStream)this.supplier.get()).write(partialMessage);
                if (last && Objects.nonNull(this.expectResponse)) {
                    this.expectResponse.complete(this.responseHeader);
                }
            }
            catch (IOException e) {
                LOG.error("could not write response data.", (Throwable)e);
                this.closeSession(this.session, "could not write to temp file", WebSocketCloseCode.INTERNAL_ERROR);
            }
        } else {
            super.onMessage(partialMessage, last);
        }
    }

    private void closeSession(Session session, String reason, WebSocketCloseCode webSocketCloseCode) {
        try {
            session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(webSocketCloseCode), reason));
        }
        catch (IOException ex) {
            LOG.error("could not close session.", (Throwable)ex);
        }
    }

    public boolean isOpen() {
        if (this.session == null) {
            return false;
        }
        return this.session.isOpen();
    }
}

