/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api;

import de.ponton.api.websocket.WebSocketAdapterAccessException;
import de.ponton.api.websocket.WebSocketConnection;
import de.ponton.xp.adapter.api.ArtifactTypeEnum;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiverException;
import de.pontonconsulting.xmlpipe.messenger.archive.IArchiver;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class WebSocketAdapterInfo
extends AdapterInfo
implements IArchiver {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final AtomicBoolean ready = new AtomicBoolean();
    private final HashMap<Session, WebSocketConnection> inboundWebSocketConnections = new HashMap();
    private final BlockingQueue<WebSocketConnection> availableInboundWebSocketConnections = new ArrayBlockingQueue<WebSocketConnection>(100, true);
    private final HashSet<WebSocketConnection> borrowedInboundWebSocketConnections = new HashSet();
    private final HashMap<Session, WebSocketConnection> outboundWebSocketConnections = new HashMap();
    private final Map<Session, WebSocketConnection> archiveWebSocketConnections = new ConcurrentHashMap<Session, WebSocketConnection>();
    private final BlockingQueue<WebSocketConnection> availableArchiveWebSocketConnections = new ArrayBlockingQueue<WebSocketConnection>(100, true);
    private final HashSet<WebSocketConnection> borrowedArchiveWebSocketConnections = new HashSet();
    private final boolean supportInboundMessage;

    public static WebSocketAdapterInfoBuilder createBuilder() {
        return new WebSocketAdapterInfoBuilder();
    }

    private WebSocketAdapterInfo(String id, String instanceId, int processingTimeout, boolean supportStatusUpdate, boolean supportErrorNotification, boolean supportInboundMessage, boolean supportArchive) {
        super(id, instanceId, processingTimeout);
        this.setSupportsAcknowledgements(supportStatusUpdate);
        this.setSupportsErrorNotification(supportErrorNotification);
        this.setSupportsArchive(supportArchive);
        this.supportInboundMessage = supportInboundMessage;
    }

    public void addWebSocketConnection(WebSocketConnection webSocketConnection) {
        this.lock.lock();
        try {
            if (webSocketConnection.isInboundConnection()) {
                this.inboundWebSocketConnections.put(webSocketConnection.getSession(), webSocketConnection);
                this.availableInboundWebSocketConnections.add(webSocketConnection);
            } else if (webSocketConnection.isArchiveConnection()) {
                this.archiveWebSocketConnections.put(webSocketConnection.getSession(), webSocketConnection);
                this.availableArchiveWebSocketConnections.add(webSocketConnection);
            } else {
                this.outboundWebSocketConnections.put(webSocketConnection.getSession(), webSocketConnection);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeSession(Session session) {
        this.lock.lock();
        try {
            WebSocketConnection connection = this.archiveWebSocketConnections.remove(session);
            if (connection != null) {
                this.availableArchiveWebSocketConnections.remove(connection);
                this.borrowedArchiveWebSocketConnections.remove(connection);
                return;
            }
            connection = this.inboundWebSocketConnections.remove(session);
            if (connection != null) {
                this.availableInboundWebSocketConnections.remove(connection);
                this.borrowedInboundWebSocketConnections.remove(connection);
            } else {
                this.outboundWebSocketConnections.remove(session);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isWebSocketAdapter() {
        return true;
    }

    @Override
    public int getMaximumThreads() {
        return this.inboundWebSocketConnections.size();
    }

    @Override
    public boolean isDown() {
        return !this.ready.get() || this.getMaximumThreads() == 0;
    }

    public String getStatus() {
        try {
            return MessageFormat.format("inbound connections:{0} outbound connections:{1} message:{2}", this.inboundWebSocketConnections.size(), this.outboundWebSocketConnections.size(), this.getAdapterStatusMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return "ERROR: the call was interrupted";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAdapterStatusMessage() throws InterruptedException {
        WebSocketConnection webSocketConnection = null;
        try {
            webSocketConnection = this.borrowInboundConnection();
            String string = webSocketConnection.requestAdapterStatusUpdate();
            return string;
        }
        catch (WebSocketAdapterAccessException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            this.releaseInboundConnection(webSocketConnection);
        }
    }

    public WebSocketConnection borrowInboundConnection() throws WebSocketAdapterAccessException, InterruptedException {
        WebSocketConnection connection = this.availableInboundWebSocketConnections.poll(this.getProcessingTimeout(), TimeUnit.SECONDS);
        if (Objects.nonNull(connection)) {
            this.lock.lock();
            try {
                this.borrowedInboundWebSocketConnections.add(connection);
            }
            finally {
                this.lock.unlock();
            }
            return connection;
        }
        throw new WebSocketAdapterAccessException("no inbound adapter connection available for " + this.getProcessingTimeout() + "ms");
    }

    public void releaseInboundConnection(WebSocketConnection connection) {
        this.lock.lock();
        try {
            if (this.borrowedInboundWebSocketConnections.remove(connection)) {
                this.availableInboundWebSocketConnections.add(connection);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private WebSocketConnection borrowArchiveConnection() throws WebSocketAdapterAccessException, InterruptedException {
        WebSocketConnection connection = this.availableArchiveWebSocketConnections.poll(this.getProcessingTimeout(), TimeUnit.SECONDS);
        if (Objects.nonNull(connection)) {
            this.lock.lock();
            try {
                this.borrowedArchiveWebSocketConnections.add(connection);
            }
            finally {
                this.lock.unlock();
            }
            return connection;
        }
        throw new WebSocketAdapterAccessException("no archive adapter connection available for " + this.getProcessingTimeout() + "ms");
    }

    private void releaseArchiveConnection(WebSocketConnection connection) {
        this.lock.lock();
        try {
            if (this.borrowedArchiveWebSocketConnections.remove(connection)) {
                this.availableArchiveWebSocketConnections.add(connection);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setReadyForMessages(boolean ready) {
        this.ready.set(ready);
    }

    @Override
    public boolean supportsAcknowledgements() {
        return true;
    }

    public boolean supportsInboundMessage() {
        return this.supportInboundMessage;
    }

    private IArchiver.ArchiveResponse sendFileToArchive(MessageInfo messageInfo, WebSocketConnection webSocketConnection, boolean isFailedMessage, IArchiver.File2Archive file2archive) throws ArchiverException {
        IArchiver.ArchiveResponse archiveResponse;
        block9: {
            SimpleProperties simpleProperties = new SimpleProperties();
            simpleProperties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveStoreData.toString());
            simpleProperties.setProperty(ArchivePropertiesEnum.MESSAGE_ID, messageInfo.getMessageId());
            simpleProperties.setProperty(ArchivePropertiesEnum.TIMESTAMP, String.valueOf(messageInfo.getTimestamp()));
            simpleProperties.setProperty(ArchivePropertiesEnum.MESSAGE_UNIQUE_ID, String.valueOf(messageInfo.getDatabaseId()));
            simpleProperties.setProperty(ArchivePropertiesEnum.IS_INBOUND, String.valueOf(messageInfo.isInbound()));
            simpleProperties.setProperty(ArchivePropertiesEnum.ARTIFACT_TYPE, ArtifactTypeEnum.valueOf((String)file2archive.fileType().name()).toString());
            simpleProperties.setProperty(ArchivePropertiesEnum.FAILED, Boolean.toString(isFailedMessage));
            simpleProperties.setProperty(ArchivePropertiesEnum.FILE_NAME, file2archive.fileName());
            InputStream inputStream = file2archive.inputStream();
            try {
                SimpleProperties responseHeader = webSocketConnection.send(simpleProperties, Optional.of(inputStream));
                if (responseHeader.containsProperty(ArchivePropertiesEnum.ERROR_MESSAGE)) {
                    throw new ArchiverException(responseHeader.getProperty(ArchivePropertiesEnum.ERROR_MESSAGE));
                }
                archiveResponse = new IArchiver.ArchiveResponse(responseHeader.getProperty(ArchivePropertiesEnum.REFERENCE_ID), file2archive.fileName(), file2archive.fileType());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                    throw new ArchiverException("Error while sending files to archive", e);
                }
            }
            inputStream.close();
        }
        return archiveResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IArchiver.ArchiveResponse> sendFilesToArchive(MessageInfo messageInfo, boolean isFailedMessage, List<IArchiver.File2Archive> files2archive) throws ArchiverException {
        if (this.archiveWebSocketConnections.isEmpty()) {
            throw new ArchiverException("Archiver is not available");
        }
        try {
            ArrayList<IArchiver.ArchiveResponse> response = new ArrayList<IArchiver.ArchiveResponse>();
            for (IArchiver.File2Archive file2Archive : files2archive) {
                WebSocketConnection webSocketConnection = this.borrowArchiveConnection();
                try {
                    response.add(this.sendFileToArchive(messageInfo, webSocketConnection, isFailedMessage, file2Archive));
                }
                finally {
                    this.releaseArchiveConnection(webSocketConnection);
                }
            }
            return response;
        }
        catch (WebSocketAdapterAccessException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ArchiverException("Error while sending files to archive", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFileFromArchive(String archiveReference, OutputStream outputStream) throws ArchiverException {
        if (this.archiveWebSocketConnections.isEmpty()) {
            throw new ArchiverException("Archiver is not available");
        }
        try {
            SimpleProperties simpleProperties = new SimpleProperties();
            simpleProperties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveGetData.toString());
            simpleProperties.setProperty(ArchivePropertiesEnum.REFERENCE_ID, archiveReference);
            WebSocketConnection webSocketConnection = this.borrowArchiveConnection();
            try {
                SimpleProperties responseHeader = webSocketConnection.receive(simpleProperties, () -> outputStream);
                if (responseHeader.containsProperty(ArchivePropertiesEnum.ERROR_MESSAGE)) {
                    throw new ArchiverException(responseHeader.getProperty(ArchivePropertiesEnum.ERROR_MESSAGE));
                }
            }
            finally {
                this.releaseArchiveConnection(webSocketConnection);
            }
        }
        catch (WebSocketAdapterAccessException | IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new ArchiverException("Error while reading file from archive", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFileFromArchive(List<String> archiveReferences2delete) throws ArchiverException {
        if (this.archiveWebSocketConnections.isEmpty()) {
            throw new ArchiverException("Archiver is not available");
        }
        try {
            for (String archiveReference : archiveReferences2delete) {
                SimpleProperties simpleProperties = new SimpleProperties();
                simpleProperties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveDeleteData.toString());
                simpleProperties.setProperty(ArchivePropertiesEnum.REFERENCE_ID, archiveReference);
                WebSocketConnection webSocketConnection = this.borrowArchiveConnection();
                try {
                    SimpleProperties responseHeader = webSocketConnection.send(simpleProperties, Optional.empty());
                    if (!responseHeader.containsProperty(ArchivePropertiesEnum.ERROR_MESSAGE)) continue;
                    throw new ArchiverException(responseHeader.getProperty(ArchivePropertiesEnum.ERROR_MESSAGE));
                }
                finally {
                    this.releaseArchiveConnection(webSocketConnection);
                }
            }
        }
        catch (WebSocketAdapterAccessException | IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new ArchiverException("Error while deleting file from archive", e);
        }
    }

    public static class WebSocketAdapterInfoBuilder {
        private String id;
        private String instanceId;
        private int processingTimeout;
        private boolean supportStatusUpdate;
        private boolean supportErrorNotification;
        private boolean supportInboundMessage;
        private boolean supportArchive;

        private WebSocketAdapterInfoBuilder() {
        }

        public WebSocketAdapterInfoBuilder setAdapterId(String id) {
            this.id = id;
            return this;
        }

        public WebSocketAdapterInfoBuilder setAdapterInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public WebSocketAdapterInfoBuilder setProcessingTimeout(int processingTimeout) {
            this.processingTimeout = processingTimeout;
            return this;
        }

        public WebSocketAdapterInfoBuilder setSupportStatusUpdate(boolean supportStatusUpdate) {
            this.supportStatusUpdate = supportStatusUpdate;
            return this;
        }

        public WebSocketAdapterInfoBuilder setSupportErrorNotification(boolean supportErrorNotification) {
            this.supportErrorNotification = supportErrorNotification;
            return this;
        }

        public WebSocketAdapterInfoBuilder setSupportInboundMessage(boolean supportInboundMessage) {
            this.supportInboundMessage = supportInboundMessage;
            return this;
        }

        public WebSocketAdapterInfoBuilder setSupportArchive(boolean supportArchive) {
            this.supportArchive = supportArchive;
            return this;
        }

        public WebSocketAdapterInfo build() {
            return new WebSocketAdapterInfo(this.id, this.instanceId, this.processingTimeout, this.supportStatusUpdate, this.supportErrorNotification, this.supportInboundMessage, this.supportArchive);
        }
    }
}

