/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages.internal;

import de.ponton.xp.adapter.api.domainvalues.ConversationId;
import de.ponton.xp.adapter.api.domainvalues.CreationTime;
import de.ponton.xp.adapter.api.domainvalues.ErrorNotificationResultEnum;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.ReceiverId;
import de.ponton.xp.adapter.api.domainvalues.ReceptionTime;
import de.ponton.xp.adapter.api.domainvalues.SenderId;
import de.ponton.xp.adapter.api.messages.ErrorNotification;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ErrorNotificationImpl
implements ErrorNotification {
    private final ReceiverId receiverId;
    private final SenderId senderId;
    private final MessageId messageId;
    private final ConversationId conversationId;
    private final MessageType messageType;
    private final ReceptionTime receptionTime;
    private final CreationTime creationTime;
    private final Map<String, ProcessingDirective> processingDirectives;
    private final MessageUniqueId messageUniqueId;
    private final ErrorNotificationResultEnum result;
    private final String resultDetailText;

    private ErrorNotificationImpl(ReceiverId receiverId, SenderId senderId, MessageId messageId, ConversationId conversationId, MessageType messageType, ReceptionTime receptionTime, CreationTime creationTime, Map<String, ProcessingDirective> processingDirectives, MessageUniqueId messageUniqueId, ErrorNotificationResultEnum result, String resultDetailText) {
        this.receiverId = receiverId;
        this.senderId = senderId;
        this.messageId = messageId;
        this.conversationId = conversationId;
        this.messageType = messageType;
        this.receptionTime = receptionTime;
        this.creationTime = creationTime;
        this.processingDirectives = processingDirectives;
        this.messageUniqueId = messageUniqueId;
        this.result = result;
        this.resultDetailText = resultDetailText;
    }

    public static ErrorNotificationBuilder newBuilder() {
        return new ErrorNotificationBuilder();
    }

    @Override
    public ReceiverId getReceiverId() {
        return this.receiverId;
    }

    @Override
    public SenderId getSenderId() {
        return this.senderId;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public ConversationId getConversationId() {
        return this.conversationId;
    }

    @Override
    public Optional<MessageType> getMessageType() {
        return Optional.ofNullable(this.messageType);
    }

    @Override
    public ReceptionTime getReceptionTime() {
        return this.receptionTime;
    }

    @Override
    public CreationTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Map<String, ProcessingDirective> getProcessingDirectives() {
        return this.processingDirectives;
    }

    @Override
    public ProcessingDirective getProcessingDirective(String key) {
        return this.processingDirectives.get(key);
    }

    @Override
    public MessageUniqueId getMessageUniqueId() {
        return this.messageUniqueId;
    }

    @Override
    public ErrorNotificationResultEnum getResult() {
        return this.result;
    }

    @Override
    public String getDetailText() {
        return this.resultDetailText;
    }

    public String toString() {
        return "ErrorNotificationImpl{receiverId=" + String.valueOf(this.receiverId) + ", senderId=" + String.valueOf(this.senderId) + ", messageId=" + String.valueOf(this.messageId) + ", conversationId=" + String.valueOf(this.conversationId) + ", messageType=" + String.valueOf(this.messageType) + ", receptionTime=" + String.valueOf(this.receptionTime) + ", creationTime=" + String.valueOf(this.creationTime) + ", processingDirectives=" + String.valueOf(this.processingDirectives) + ", messageUniqueId=" + String.valueOf(this.messageUniqueId) + ", result=" + String.valueOf((Object)this.result) + ", resultDetailText='" + this.resultDetailText + "'}";
    }

    public static class ErrorNotificationBuilder {
        private final Map<String, ProcessingDirective> processingDirectives = new ConcurrentHashMap<String, ProcessingDirective>();
        private ReceiverId receiverId;
        private SenderId senderId;
        private MessageId messageId;
        private ConversationId conversationId;
        private MessageType messageType;
        private ReceptionTime receptionTime;
        private CreationTime creationTime;
        private MessageUniqueId messageUniqueId;
        private ErrorNotificationResultEnum result;
        private String resultDetailText;

        private ErrorNotificationBuilder() {
        }

        public ReceiverId getReceiverId() {
            return this.receiverId;
        }

        public ErrorNotificationBuilder setReceiverId(ReceiverId receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public SenderId getSenderId() {
            return this.senderId;
        }

        public ErrorNotificationBuilder setSenderId(SenderId senderId) {
            this.senderId = senderId;
            return this;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public ErrorNotificationBuilder setMessageId(MessageId messageId) {
            this.messageId = messageId;
            return this;
        }

        public ConversationId getConversationId() {
            return this.conversationId;
        }

        public ErrorNotificationBuilder setConversationId(ConversationId conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public MessageType getMessageType() {
            return this.messageType;
        }

        public ErrorNotificationBuilder setMessageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public ReceptionTime getReceptionTime() {
            return this.receptionTime;
        }

        public ErrorNotificationBuilder setReceptionTime(ReceptionTime receptionTime) {
            this.receptionTime = receptionTime;
            return this;
        }

        public CreationTime getCreationTime() {
            return this.creationTime;
        }

        public ErrorNotificationBuilder setCreationTime(CreationTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Map<String, ProcessingDirective> getProcessingDirectives() {
            return this.processingDirectives;
        }

        public ErrorNotificationBuilder addProcessingDirective(ProcessingDirective processingDirective) {
            this.processingDirectives.put(processingDirective.getName(), processingDirective);
            return this;
        }

        public ErrorNotificationBuilder addProcessingDirectives(List<ProcessingDirective> processingDirectives) {
            processingDirectives.forEach(processingDirective -> this.processingDirectives.put(processingDirective.getName(), (ProcessingDirective)processingDirective));
            return this;
        }

        public MessageUniqueId getMessageUniqueId() {
            return this.messageUniqueId;
        }

        public ErrorNotificationBuilder setMessageUniqueId(MessageUniqueId messageUniqueId) {
            this.messageUniqueId = messageUniqueId;
            return this;
        }

        public ErrorNotificationResultEnum getResult() {
            return this.result;
        }

        public ErrorNotificationBuilder setResult(ErrorNotificationResultEnum result) {
            this.result = result;
            return this;
        }

        public String getResultDetailText() {
            return this.resultDetailText;
        }

        public ErrorNotificationBuilder setResultDetailText(String resultDetailText) {
            this.resultDetailText = resultDetailText;
            return this;
        }

        public ErrorNotification build() {
            return new ErrorNotificationImpl(this.receiverId, this.senderId, this.messageId, this.conversationId, this.messageType, this.receptionTime, this.creationTime, this.processingDirectives, this.messageUniqueId, this.result, this.resultDetailText);
        }
    }
}

