/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages.internal;

import de.ponton.xp.adapter.api.ArtifactTypeEnum;
import de.ponton.xp.adapter.api.domainvalues.Filename;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.messages.ArchiveStoreMessage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveStoreMessageImpl
implements ArchiveStoreMessage {
    private static final Logger LOG = Logger.getLogger(ArchiveStoreMessageImpl.class.getName());
    private final MessageId messageId;
    private final MessageUniqueId messageUniqueId;
    private final boolean isInbound;
    private final ArtifactTypeEnum artifactType;
    private final boolean isFailed;
    private final Filename filename;
    private final Instant timestamp;
    private final Path path;
    private final List<InputStream> createdInputStreams;

    public static ArchiveStoreMessageBuilder newBuilder() {
        return new ArchiveStoreMessageBuilder();
    }

    private ArchiveStoreMessageImpl(MessageId messageId, MessageUniqueId messageUniqueId, Boolean isInbound, ArtifactTypeEnum artifactType, Boolean isFailed, Filename filename, Instant timestamp, Path path) {
        Objects.requireNonNull(messageId, "messageId must not be NULL");
        Objects.requireNonNull(messageUniqueId, "messageUniqueId must not be NULL");
        Objects.requireNonNull(isInbound, "isInbound must not be NULL");
        Objects.requireNonNull(artifactType, "artifactType must not be NULL");
        Objects.requireNonNull(isFailed, "isFailed must not be NULL");
        Objects.requireNonNull(timestamp, "timestamp must not be NULL");
        Objects.requireNonNull(path, "path must not be NULL");
        this.messageId = messageId;
        this.messageUniqueId = messageUniqueId;
        this.isInbound = isInbound;
        this.artifactType = artifactType;
        this.isFailed = isFailed;
        this.filename = filename;
        this.timestamp = timestamp;
        this.path = path;
        this.createdInputStreams = new ArrayList<InputStream>();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));
        this.createdInputStreams.add(inputStream);
        return inputStream;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public MessageUniqueId getMessageUniqueId() {
        return this.messageUniqueId;
    }

    @Override
    public boolean isInbound() {
        return this.isInbound;
    }

    @Override
    public ArtifactTypeEnum getArtifactType() {
        return this.artifactType;
    }

    @Override
    public boolean isFailed() {
        return this.isFailed;
    }

    @Override
    public Optional<Filename> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void purge() {
        for (InputStream inputStream : this.createdInputStreams) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not close input stream.", e);
            }
        }
    }

    public static class ArchiveStoreMessageBuilder {
        private MessageId messageId;
        private MessageUniqueId messageUniqueId;
        private Boolean isInbound;
        private ArtifactTypeEnum artifactType;
        private Boolean isFailed;
        private Filename filename;
        private Instant timestamp;
        private Path path;

        public ArchiveStoreMessageBuilder setArtifactType(ArtifactTypeEnum artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public ArchiveStoreMessageBuilder setFilename(Filename filename) {
            this.filename = filename;
            return this;
        }

        public ArchiveStoreMessageBuilder setFailed(Boolean failed) {
            this.isFailed = failed;
            return this;
        }

        public ArchiveStoreMessageBuilder setInbound(Boolean inbound) {
            this.isInbound = inbound;
            return this;
        }

        public ArchiveStoreMessageBuilder setMessageId(MessageId messageId) {
            this.messageId = messageId;
            return this;
        }

        public ArchiveStoreMessageBuilder setMessageUniqueId(MessageUniqueId messageUniqueId) {
            this.messageUniqueId = messageUniqueId;
            return this;
        }

        public ArchiveStoreMessageBuilder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ArchiveStoreMessageBuilder setPath(Path path) {
            this.path = path;
            return this;
        }

        public ArchiveStoreMessageImpl build() {
            return new ArchiveStoreMessageImpl(this.messageId, this.messageUniqueId, this.isInbound, this.artifactType, this.isFailed, this.filename, this.timestamp, this.path);
        }
    }
}

