/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages;

import de.ponton.xp.adapter.api.domainvalues.InboundStatusEnum;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.messages.InboundMessage;
import java.util.Objects;

public class InboundMessageStatusUpdate {
    private final MessageId messageId;
    private final InboundStatusEnum status;
    private final String statusText;

    public static InboundMessageStatusUpdateBuilder newBuilder() {
        return new InboundMessageStatusUpdateBuilder();
    }

    private InboundMessageStatusUpdate(MessageId messageId, InboundStatusEnum status, String statusText) {
        Objects.requireNonNull(messageId, "messageId must not be NULL");
        Objects.requireNonNull(status, "status must not be NULL");
        Objects.requireNonNull(statusText, "statusText must not be NULL");
        this.messageId = messageId;
        this.status = status;
        this.statusText = statusText;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public InboundStatusEnum getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public static class InboundMessageStatusUpdateBuilder {
        private InboundStatusEnum status;
        private String text;
        private InboundMessage inboundMessage;

        public InboundMessageStatusUpdateBuilder setInboundMessage(InboundMessage inboundMessage) {
            this.inboundMessage = inboundMessage;
            return this;
        }

        public InboundMessageStatusUpdateBuilder setStatus(InboundStatusEnum status) {
            this.status = status;
            return this;
        }

        public InboundMessageStatusUpdateBuilder setStatusText(String text) {
            this.text = text;
            return this;
        }

        public InboundMessageStatusUpdate build() {
            return new InboundMessageStatusUpdate(this.inboundMessage.getInboundMetaData().getMessageId(), this.status, this.text);
        }
    }
}

