/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages;

import de.ponton.xp.adapter.api.domainvalues.ConversationId;
import de.ponton.xp.adapter.api.domainvalues.CreationTime;
import de.ponton.xp.adapter.api.domainvalues.DisplayName;
import de.ponton.xp.adapter.api.domainvalues.ErrorNotificationResultEnum;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeName;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeVersion;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.domainvalues.MimeType;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.ReceiverId;
import de.ponton.xp.adapter.api.domainvalues.SchemaSet;
import de.ponton.xp.adapter.api.domainvalues.SenderId;
import de.ponton.xp.adapter.api.domainvalues.internal.ReceptionTimeImpl;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.messages.ErrorNotification;
import de.ponton.xp.adapter.api.messages.internal.ErrorNotificationImpl;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ErrorNotificationFactory {
    private static final ErrorNotificationFactory instance = new ErrorNotificationFactory();
    private static final String UNKNOWN_VALUE = "UNKNOWN";

    public static ErrorNotificationFactory getInstance() {
        return instance;
    }

    public ErrorNotification createErrorNotification(SimpleProperties properties) {
        ErrorNotificationImpl.ErrorNotificationBuilder errorNotificationBuilder = ErrorNotificationImpl.newBuilder().setMessageUniqueId(new MessageUniqueId(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID)))).setSenderId(new SenderId(properties.getProperty(MetaDataPropertiesEnum.SENDER_ID))).setReceiverId(new ReceiverId(properties.getProperty(MetaDataPropertiesEnum.RECEIVER_ID))).setMessageId(new MessageId(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_ID))).setConversationId(new ConversationId(properties.getProperty(MetaDataPropertiesEnum.CONVERSATION_ID))).setCreationTime(new CreationTime(Instant.ofEpochMilli(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.CREATION_TIME))))).setReceptionTime(new ReceptionTimeImpl(Instant.ofEpochMilli(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.RECEPTION_TIME))))).setResult(ErrorNotificationResultEnum.valueOf(properties.getProperty(AdapterPropertiesEnum.RESULT))).setResultDetailText(properties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT)).addProcessingDirectives(this.getProcessingDirectives(properties));
        if (this.isMessageTypeSet(properties)) {
            errorNotificationBuilder.setMessageType(MessageType.newBuilder().setName(new MessageTypeName(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE))).setVersion(new MessageTypeVersion(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_VERSION))).setSchemaSet(new SchemaSet(properties.getProperty(MetaDataPropertiesEnum.SCHEMA_SET))).setDisplayName(new DisplayName(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME))).setMimeType(new MimeType(properties.getProperty(MetaDataPropertiesEnum.MIME_TYPE))).build());
        }
        return errorNotificationBuilder.build();
    }

    private boolean isMessageTypeSet(SimpleProperties properties) {
        if (UNKNOWN_VALUE.equals(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE))) {
            return false;
        }
        if (UNKNOWN_VALUE.equals(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_VERSION))) {
            return false;
        }
        return !UNKNOWN_VALUE.equals(properties.getProperty(MetaDataPropertiesEnum.SCHEMA_SET));
    }

    private List<ProcessingDirective> getProcessingDirectives(SimpleProperties properties) {
        ArrayList<ProcessingDirective> processingDirectives = new ArrayList<ProcessingDirective>();
        Map<String, String> processingDirectiveValues = properties.getProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE);
        for (Map.Entry<String, String> entry : processingDirectiveValues.entrySet()) {
            processingDirectives.add(ProcessingDirective.create(entry.getKey(), entry.getValue()));
        }
        return processingDirectives;
    }
}

