/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal.security;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;

public class UniqueId {
    private static final String RSA = "RSA";
    private static final String ID_FILE = "id.dat";
    private final File folder;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    UniqueId(File folder) {
        Objects.requireNonNull(folder);
        if (!folder.exists()) {
            throw new IllegalArgumentException("folder " + String.valueOf(folder) + " does not exist");
        }
        this.folder = folder;
    }

    public void generate() throws GeneralSecurityException, IOException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        try (FileOutputStream keyFile = new FileOutputStream(new File(this.folder, ID_FILE));
             DataOutputStream dataOutputStream = new DataOutputStream(keyFile);){
            byte[] encodedPublicKey = this.getEncodedPublicKey();
            dataOutputStream.writeShort(encodedPublicKey.length);
            dataOutputStream.write(encodedPublicKey);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(this.privateKey.getEncoded());
            byte[] encodedPrivateKey = pkcs8EncodedKeySpec.getEncoded();
            dataOutputStream.writeShort(encodedPrivateKey.length);
            dataOutputStream.write(encodedPrivateKey);
        }
    }

    public void load() throws GeneralSecurityException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(new File(this.folder, ID_FILE));
             DataInputStream inputStream = new DataInputStream(fileInputStream);){
            short publicSize = inputStream.readShort();
            byte[] encodedPublic = new byte[publicSize];
            inputStream.readFully(encodedPublic);
            short privateSize = inputStream.readShort();
            byte[] encodedPrivate = new byte[privateSize];
            inputStream.readFully(encodedPrivate);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(encodedPublic);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivate);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            this.privateKey = keyFactory.generatePrivate(privateKeySpec);
            this.publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncodedPublicKey() {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.getPublicKey().getEncoded());
        return x509EncodedKeySpec.getEncoded();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

