/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal.messages;

import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;

public class ProtocolChallengeResponseMessage
extends ProtocolMessage {
    public static ProtocolChallengeResponseMessageBuilder createBuilder() {
        return new ProtocolChallengeResponseMessageBuilder();
    }

    private ProtocolChallengeResponseMessage(String adapterApiVersion, String adapterId, String adapterVersion, int adapterProcessingTimeout, boolean adapterSupportsStatusUpdate, boolean adapterSupportsErrorNotification, boolean adapterSupportsInboundMessage, boolean adapterSupportsArchive) {
        super(ProtocolMessageTypeEnum.ChallengeResponseMessage);
        this.setProperty(AdapterPropertiesEnum.API_VERSION.toString(), adapterApiVersion);
        this.setProperty(AdapterPropertiesEnum.ADAPTER_ID.toString(), adapterId);
        this.setProperty(AdapterPropertiesEnum.ADAPTER_VERSION.toString(), adapterVersion);
        this.setProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_STATUS_UPDATE.toString(), String.valueOf(adapterSupportsStatusUpdate));
        this.setProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_ERROR_NOTIFICATION.toString(), String.valueOf(adapterSupportsErrorNotification));
        this.setProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_INBOUND_MESSAGE.toString(), String.valueOf(adapterSupportsInboundMessage));
        this.setProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_ARCHIVE.toString(), String.valueOf(adapterSupportsArchive));
        if (adapterProcessingTimeout > 0) {
            this.setProperty(AdapterPropertiesEnum.ADAPTER_PROCESSING_TIMEOUT.toString(), String.valueOf(adapterProcessingTimeout));
        }
    }

    public static class ProtocolChallengeResponseMessageBuilder {
        private String adapterApiVersion;
        private String adapterId;
        private String adapterVersion;
        private int adapterProcessingTimeout;
        private boolean supportErrorNotification = false;
        private boolean supportStatusUpdate = true;
        private boolean supportInboundMessage = true;
        private boolean supportArchiving = false;

        public ProtocolChallengeResponseMessageBuilder setAdapterApiVersion(String adapterApiVersion) {
            this.adapterApiVersion = adapterApiVersion;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setAdapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setAdapterProcessingTimeout(int adapterProcessingTimeout) {
            this.adapterProcessingTimeout = adapterProcessingTimeout;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setSupportErrorNotification(boolean supportErrorNotification) {
            this.supportErrorNotification = supportErrorNotification;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setSupportStatusUpdate(boolean supportStatusUpdate) {
            this.supportStatusUpdate = supportStatusUpdate;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setSupportInboundMessage(boolean supportInboundMessage) {
            this.supportInboundMessage = supportInboundMessage;
            return this;
        }

        public ProtocolChallengeResponseMessageBuilder setSupportArchiving(boolean supportArchiving) {
            this.supportArchiving = supportArchiving;
            return this;
        }

        public ProtocolChallengeResponseMessage build() {
            return new ProtocolChallengeResponseMessage(this.adapterApiVersion, this.adapterId, this.adapterVersion, this.adapterProcessingTimeout, this.supportStatusUpdate, this.supportErrorNotification, this.supportInboundMessage, this.supportArchiving);
        }
    }
}

