/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.OutboundMessageStatusUpdateHandler;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolOutboundMessageStatusUpdateResponse;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdate;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdateFactory;
import java.net.http.WebSocket;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatusUpdateHandler {
    private static final Logger LOG = Logger.getLogger(StatusUpdateHandler.class.getName());
    private final OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler;

    StatusUpdateHandler(OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler) {
        this.outboundMessageStatusUpdateHandler = outboundMessageStatusUpdateHandler;
    }

    void handleOnText(SimpleProperties properties, WebSocket webSocket) {
        try {
            OutboundMessageStatusUpdate outboundMessageStatusUpdate = OutboundMessageStatusUpdateFactory.getInstance().createOutboundMessageStatusUpdate(properties);
            if (Objects.nonNull(this.outboundMessageStatusUpdateHandler)) {
                this.outboundMessageStatusUpdateHandler.onOutboundMessageStatusUpdate(outboundMessageStatusUpdate);
            }
            this.sendResponse(webSocket, StatusUpdateResponseEnum.SUCCESS, "Status update successfully received.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not process status update.", e);
            this.sendResponse(webSocket, StatusUpdateResponseEnum.REJECTED, "Could not process status update: " + String.valueOf(e));
        }
    }

    private void sendResponse(WebSocket webSocket, StatusUpdateResponseEnum status, String detailText) {
        ProtocolOutboundMessageStatusUpdateResponse protocolOutboundMessageStatusUpdateResponse = ProtocolOutboundMessageStatusUpdateResponse.createBuilder().setResult(status).setDetailText(detailText).build();
        webSocket.sendText(protocolOutboundMessageStatusUpdateResponse.toWireFormat(), true);
    }
}

