/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ArchiveException;
import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.messages.ArchiveGetResponse;
import de.ponton.xp.adapter.api.messages.internal.ArchiveGetMessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveGetMessageHandler {
    private static final Logger LOG = Logger.getLogger(ArchiveGetMessageHandler.class.getName());
    private final ArchiveHandler archiveHandler;

    ArchiveGetMessageHandler(ArchiveHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    void handleOnText(SimpleProperties properties, WebSocket archiveWebSocket) {
        try {
            try {
                String archiveReference = properties.getProperty(ArchivePropertiesEnum.REFERENCE_ID);
                ArchiveGetResponse archiveGetResponse = this.archiveHandler.onMessage(ArchiveGetMessageImpl.newBuilder().setArchiveReference(archiveReference).build());
                this.sendResponse(archiveWebSocket, archiveGetResponse);
            }
            catch (ArchiveException e) {
                this.sendError(e.getMessage(), archiveWebSocket);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not get archived data.", e);
        }
    }

    private void sendError(String errorMessage, WebSocket archiveWebSocket) throws IOException, ExecutionException, InterruptedException {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveGetDataResponse.name());
        properties.setProperty(ArchivePropertiesEnum.ERROR_MESSAGE, errorMessage);
        this.waitForWebSocketTransmission(archiveWebSocket.sendText(properties.getWireFormat(), true));
    }

    private void sendResponse(WebSocket archiveWebSocket, ArchiveGetResponse archiveGetResponse) throws IOException, ExecutionException, InterruptedException {
        byte[] buffer = new byte[8192];
        int totalSize = 0;
        try (InputStream data = archiveGetResponse.createInputStream();){
            int size;
            SimpleProperties properties = new SimpleProperties();
            properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveGetDataResponse.name());
            this.waitForWebSocketTransmission(archiveWebSocket.sendText(properties.getWireFormat(), true));
            while ((size = data.read(buffer)) > -1) {
                totalSize += size;
                this.waitForWebSocketTransmission(archiveWebSocket.sendBinary(ByteBuffer.wrap(buffer, 0, size), false));
            }
        }
        this.waitForWebSocketTransmission(archiveWebSocket.sendBinary(ByteBuffer.wrap(new byte[0]), true));
        LOG.finer("sent " + totalSize + " bytes on " + String.valueOf(archiveWebSocket));
    }

    private void waitForWebSocketTransmission(CompletableFuture<WebSocket> future) throws InterruptedException, ExecutionException, IOException {
        WebSocket webSocket = future.get();
        if (webSocket.isOutputClosed() || webSocket.isInputClosed()) {
            throw new IOException("WebSocket is closed");
        }
    }
}

