/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ArchiveException;
import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.messages.internal.ArchiveDeleteMessageImpl;
import java.io.IOException;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveDeleteMessageHandler {
    private static final Logger LOG = Logger.getLogger(ArchiveDeleteMessageHandler.class.getName());
    private final ArchiveHandler archiveHandler;

    ArchiveDeleteMessageHandler(ArchiveHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    void handleOnText(SimpleProperties properties, WebSocket archiveWebSocket) {
        try {
            try {
                this.archiveHandler.onMessage(ArchiveDeleteMessageImpl.newBuilder().setArchiveReference(properties.getProperty(ArchivePropertiesEnum.REFERENCE_ID)).build());
                this.sendResponse(archiveWebSocket);
            }
            catch (ArchiveException e) {
                this.sendError(e.getMessage(), archiveWebSocket);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not delete archived data.", e);
        }
    }

    private void sendError(String errorText, WebSocket archiveWebSocket) throws IOException, ExecutionException, InterruptedException {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveDeleteDataResponse.name());
        properties.setProperty(ArchivePropertiesEnum.ERROR_MESSAGE, errorText);
        this.waitForWebSocketTransmission(archiveWebSocket.sendText(properties.getWireFormat(), true));
    }

    private void sendResponse(WebSocket archiveWebSocket) throws IOException, ExecutionException, InterruptedException {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.ArchiveDeleteDataResponse.name());
        this.waitForWebSocketTransmission(archiveWebSocket.sendText(properties.getWireFormat(), true));
    }

    private void waitForWebSocketTransmission(CompletableFuture<WebSocket> future) throws InterruptedException, ExecutionException, IOException {
        WebSocket webSocket = future.get();
        if (webSocket.isOutputClosed() || webSocket.isInputClosed()) {
            throw new IOException("WebSocket is closed");
        }
    }
}

