/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api;

import de.ponton.xp.adapter.api.AdapterStatusRequestHandler;
import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.ConnectionStatusChangeHandler;
import de.ponton.xp.adapter.api.ErrorNotificationHandler;
import de.ponton.xp.adapter.api.MessageHandler;
import de.ponton.xp.adapter.api.NoConnectionAvailableException;
import de.ponton.xp.adapter.api.OutboundMessageStatusUpdateHandler;
import de.ponton.xp.adapter.api.TransmissionException;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.domainvalues.MessengerInstance;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionBundle;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionBundleFactory;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import de.ponton.xp.adapter.api.internal.security.UniqueIdFactory;
import de.ponton.xp.adapter.api.messages.OutboundMessage;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdate;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class MessengerConnection {
    private static final Logger LOG = Logger.getLogger(MessengerConnection.class.getName());
    private final List<MessengerInstance> messengerInstances;
    private final AdapterInfo adapterInfo;
    private final File workFolder;
    private final AdapterStatusRequestHandler adapterStatusRequestHandler;
    private final OutboundMessageStatusUpdateHandler outboundMessageStatusHandler;
    private final ErrorNotificationHandler errorNotificationHandler;
    private final MessageHandler messageHandler;
    private final WebSocketConnectionBundleFactory websocketConnectionBundleFactory;
    private final ArchiveHandler archiveHandler;
    private final List<WebSocketConnectionBundle> webSocketConnectionBundles;
    private final UniqueId uniqueId;
    private final Signer signer;
    private final ConnectionStatusChangeHandler connectionStatusChangeHandler;
    private final AtomicInteger nextMessengerInstance = new AtomicInteger(0);

    public static MessengerConnectionBuilder newBuilder() {
        return new MessengerConnectionBuilder();
    }

    private MessengerConnection(List<MessengerInstance> messengerInstance, AdapterInfo adapterInfo, File workFolder, MessageHandler messageHandler, AdapterStatusRequestHandler adapterStatusRequestHandler, OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler, ErrorNotificationHandler errorNotificationHandler, WebSocketConnectionBundleFactory websocketConnectionBundleFactory, ArchiveHandler archiveHandler, UniqueIdFactory uniqueIdFactory, ConnectionStatusChangeHandler connectionStatusChangeHandler) throws ConnectionException {
        this.errorNotificationHandler = errorNotificationHandler;
        this.websocketConnectionBundleFactory = websocketConnectionBundleFactory;
        this.messengerInstances = Objects.requireNonNull(messengerInstance, "messengerInstance is required");
        this.archiveHandler = archiveHandler;
        this.connectionStatusChangeHandler = connectionStatusChangeHandler;
        if (this.messengerInstances.isEmpty()) {
            throw new IllegalArgumentException("messenger instances cannot be empty");
        }
        this.adapterInfo = Objects.requireNonNull(adapterInfo, "adapterInfo is required");
        this.workFolder = Objects.requireNonNullElseGet(workFolder, () -> new File("work"));
        this.messageHandler = messageHandler;
        this.adapterStatusRequestHandler = adapterStatusRequestHandler;
        this.outboundMessageStatusHandler = outboundMessageStatusUpdateHandler;
        this.uniqueId = this.loadOrCreateUniqueId(uniqueIdFactory);
        this.signer = new Signer(this.uniqueId.getPrivateKey());
        this.webSocketConnectionBundles = this.connect();
    }

    private UniqueId loadOrCreateUniqueId(UniqueIdFactory uniqueIdFactory) throws ConnectionException {
        try {
            return uniqueIdFactory.create(this.workFolder);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConnectionException("could not create unique id", e);
        }
    }

    private List<WebSocketConnectionBundle> connect() throws ConnectionException {
        return this.websocketConnectionBundleFactory.connect(this.messengerInstances, this.messageHandler, this.outboundMessageStatusHandler, this.errorNotificationHandler, this.adapterStatusRequestHandler, this.archiveHandler, this.workFolder, this.uniqueId, this.signer, this.adapterInfo, this.connectionStatusChangeHandler);
    }

    public TransferId sendMessage(OutboundMessage message) throws TransmissionException {
        int nextMessengerInstanceId = this.nextInstance();
        TransmissionException lastException = new TransmissionException("No messenger connected.");
        for (int i = 0; i < this.webSocketConnectionBundles.size(); ++i) {
            try {
                return this.webSocketConnectionBundles.get(nextMessengerInstanceId).sendMessage(message);
            }
            catch (NoConnectionAvailableException e) {
                if (++nextMessengerInstanceId >= this.webSocketConnectionBundles.size()) {
                    nextMessengerInstanceId = 0;
                }
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    public OutboundMessageStatusUpdate sendMessageSynchronously(OutboundMessage message) throws TransmissionException {
        int nextMessengerInstanceId = this.nextInstance();
        TransmissionException lastException = new TransmissionException("No messenger connected.");
        for (int i = 0; i < this.webSocketConnectionBundles.size(); ++i) {
            try {
                return this.webSocketConnectionBundles.get(nextMessengerInstanceId).sendMessageSynchronously(message);
            }
            catch (NoConnectionAvailableException e) {
                if (++nextMessengerInstanceId >= this.webSocketConnectionBundles.size()) {
                    nextMessengerInstanceId = 0;
                }
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    private synchronized int nextInstance() {
        int index = this.nextMessengerInstance.get();
        if (this.nextMessengerInstance.incrementAndGet() >= this.webSocketConnectionBundles.size()) {
            this.nextMessengerInstance.set(0);
        }
        return index;
    }

    public void close() {
        for (WebSocketConnectionBundle webSocketConnectionBundle : this.webSocketConnectionBundles) {
            webSocketConnectionBundle.close();
        }
    }

    @Deprecated
    public void start() throws TransmissionException {
        this.startReception();
    }

    public void startReception() throws TransmissionException {
        this.eachConnectionBundle(WebSocketConnectionBundle::sendStartReception);
    }

    public void pauseReception() throws TransmissionException {
        this.eachConnectionBundle(WebSocketConnectionBundle::sendPauseReception);
    }

    private void eachConnectionBundle(Lambda lambda) throws TransmissionException {
        boolean wasSuccessfulOnce = false;
        TransmissionException transmissionException = null;
        for (WebSocketConnectionBundle webSocketConnectionBundle : this.webSocketConnectionBundles) {
            try {
                lambda.apply(webSocketConnectionBundle);
                wasSuccessfulOnce = true;
            }
            catch (TransmissionException e) {
                LOG.warning(String.format("Transmission of startReception failed. %s", e.getMessage()));
                transmissionException = e;
            }
        }
        if (!wasSuccessfulOnce && transmissionException != null) {
            throw transmissionException;
        }
    }

    public static class MessengerConnectionBuilder {
        private UniqueIdFactory uniqueIdFactory;
        private final List<MessengerInstance> messengerInstances = new ArrayList<MessengerInstance>();
        private AdapterInfo adapterInfo;
        private File workFolder;
        private AdapterStatusRequestHandler adapterStatusRequestHandler;
        private OutboundMessageStatusUpdateHandler outboundMessageStatusHandler;
        private ErrorNotificationHandler errorNotificationHandler;
        private MessageHandler messageHandler;
        private WebSocketConnectionBundleFactory websocketConnectionBundleFactory = new WebSocketConnectionBundleFactory();
        private ArchiveHandler archiveHandler;
        private ConnectionStatusChangeHandler connectionStatusChangeHandler;

        private MessengerConnectionBuilder() {
            this.uniqueIdFactory = new UniqueIdFactory();
        }

        public MessengerConnectionBuilder addMessengerInstance(MessengerInstance messengerInstance) {
            this.messengerInstances.add(messengerInstance);
            return this;
        }

        public MessengerConnectionBuilder setWorkFolder(File workFolder) {
            this.workFolder = workFolder;
            return this;
        }

        public MessengerConnection build() throws ConnectionException {
            return new MessengerConnection(this.messengerInstances, this.adapterInfo, this.workFolder, this.messageHandler, this.adapterStatusRequestHandler, this.outboundMessageStatusHandler, this.errorNotificationHandler, this.websocketConnectionBundleFactory, this.archiveHandler, this.uniqueIdFactory, this.connectionStatusChangeHandler);
        }

        public MessengerConnectionBuilder onMessageReceive(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
            return this;
        }

        public MessengerConnectionBuilder onArchiveMessageReceive(ArchiveHandler archiveHandler) {
            this.archiveHandler = archiveHandler;
            return this;
        }

        public MessengerConnectionBuilder onMessageStatusUpdate(OutboundMessageStatusUpdateHandler outboundMessageStatusHandler) {
            this.outboundMessageStatusHandler = outboundMessageStatusHandler;
            return this;
        }

        public MessengerConnectionBuilder onConnectionStatusChanged(ConnectionStatusChangeHandler connectionStatusChangeHandler) {
            this.connectionStatusChangeHandler = connectionStatusChangeHandler;
            return this;
        }

        public MessengerConnectionBuilder onErrorNotification(ErrorNotificationHandler errorNotificationHandler) {
            this.errorNotificationHandler = errorNotificationHandler;
            return this;
        }

        public MessengerConnectionBuilder onAdapterStatusRequest(AdapterStatusRequestHandler adapterStatusRequestHandler) {
            this.adapterStatusRequestHandler = adapterStatusRequestHandler;
            return this;
        }

        public MessengerConnectionBuilder setAdapterInfo(AdapterInfo adapterInfo) {
            this.adapterInfo = adapterInfo;
            return this;
        }

        MessengerConnectionBuilder setWebsocketConnectionBundleFactory(WebSocketConnectionBundleFactory websocketConnectionBundleFactory) {
            this.websocketConnectionBundleFactory = websocketConnectionBundleFactory;
            return this;
        }

        MessengerConnectionBuilder setUniqueIdFactory(UniqueIdFactory uniqueIdFactory) {
            this.uniqueIdFactory = uniqueIdFactory;
            return this;
        }
    }

    @FunctionalInterface
    private static interface Lambda {
        public void apply(WebSocketConnectionBundle var1) throws TransmissionException;
    }
}

