/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.bytebuddy.utility;

import org.modelmapper.internal.asm.ClassReader;
import org.modelmapper.internal.asm.ClassVisitor;
import org.modelmapper.internal.asm.ClassWriter;
import org.modelmapper.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.modelmapper.internal.bytebuddy.description.type.TypeDescription;
import org.modelmapper.internal.bytebuddy.pool.TypePool;
import org.modelmapper.internal.bytebuddy.utility.AsmClassReader;
import org.modelmapper.internal.bytebuddy.utility.nullability.MaybeNull;

public interface AsmClassWriter {
    public ClassVisitor getVisitor();

    public byte[] getBinaryRepresentation();

    public static class FrameComputingClassWriter
    extends ClassWriter {
        private final TypePool typePool;

        public FrameComputingClassWriter(int flags, TypePool typePool) {
            super(flags);
            this.typePool = typePool;
        }

        public FrameComputingClassWriter(ClassReader classReader, int flags, TypePool typePool) {
            super(classReader, flags);
            this.typePool = typePool;
        }

        protected String getCommonSuperClass(String leftTypeName, String rightTypeName) {
            TypeDescription.Generic superClass;
            TypeDescription rightType;
            TypeDescription leftType = this.typePool.describe(leftTypeName.replace('/', '.')).resolve();
            if (leftType.isAssignableFrom(rightType = this.typePool.describe(rightTypeName.replace('/', '.')).resolve())) {
                return leftType.getInternalName();
            }
            if (leftType.isAssignableTo(rightType)) {
                return rightType.getInternalName();
            }
            if (leftType.isInterface() || rightType.isInterface()) {
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            }
            do {
                if ((superClass = leftType.getSuperClass()) != null) continue;
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            } while (!(leftType = superClass.asErasure()).isAssignableFrom(rightType));
            return leftType.getInternalName();
        }
    }

    public static class Default
    implements AsmClassWriter {
        private final ClassWriter classWriter;

        public Default(ClassWriter classWriter) {
            this.classWriter = classWriter;
        }

        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        public byte[] getBinaryRepresentation() {
            return this.classWriter.toByteArray();
        }
    }

    public static interface Factory {
        public AsmClassWriter make(int var1);

        public AsmClassWriter make(int var1, AsmClassReader var2);

        public AsmClassWriter make(int var1, TypePool var2);

        public AsmClassWriter make(int var1, AsmClassReader var2, TypePool var3);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Suppressing
        implements Factory {
            private final Factory delegate;

            public Suppressing(Factory delegate) {
                this.delegate = delegate;
            }

            public AsmClassWriter make(int flags) {
                return this.delegate.make(flags);
            }

            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.delegate.make(flags);
            }

            public AsmClassWriter make(int flags, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }

            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.delegate.equals(((Suppressing)object).delegate);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.delegate.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Default implements Factory
        {
            INSTANCE;


            @Override
            public AsmClassWriter make(int flags) {
                return this.make(flags, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.make(flags, classReader, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, TypePool typePool) {
                return new org.modelmapper.internal.bytebuddy.utility.AsmClassWriter$Default(new FrameComputingClassWriter(flags, typePool));
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                ClassReader unwrapped = classReader.unwrap(ClassReader.class);
                return new org.modelmapper.internal.bytebuddy.utility.AsmClassWriter$Default(unwrapped == null ? new FrameComputingClassWriter(flags, typePool) : new FrameComputingClassWriter(unwrapped, flags, typePool));
            }
        }
    }
}

