/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.commons.configuration2.reloading;

import shaded.org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import shaded.org.apache.commons.configuration2.io.FileHandler;
import shaded.org.apache.commons.configuration2.io.FileSystem;
import shaded.org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import shaded.org.apache.commons.logging.Log;
import shaded.org.apache.commons.logging.LogFactory;
import shaded.org.apache.commons.vfs2.FileObject;
import shaded.org.apache.commons.vfs2.FileSystemException;
import shaded.org.apache.commons.vfs2.FileSystemManager;
import shaded.org.apache.commons.vfs2.VFS;

public class VFSFileHandlerReloadingDetector
extends FileHandlerReloadingDetector {
    private final Log log = LogFactory.getLog(this.getClass());

    public VFSFileHandlerReloadingDetector() {
    }

    public VFSFileHandlerReloadingDetector(FileHandler handler, long refreshDelay) {
        super(handler, refreshDelay);
    }

    public VFSFileHandlerReloadingDetector(FileHandler handler) {
        super(handler);
    }

    @Override
    protected long getLastModificationDate() {
        FileObject file = this.getFileObject();
        try {
            if (file == null || !file.exists()) {
                return 0L;
            }
            return file.getContent().getLastModifiedTime();
        }
        catch (FileSystemException ex) {
            this.log.error("Unable to get last modified time for" + file.getName().getURI(), ex);
            return 0L;
        }
    }

    protected FileObject getFileObject() {
        if (!this.getFileHandler().isLocationDefined()) {
            return null;
        }
        try {
            FileSystemManager fsManager = VFS.getManager();
            String uri = this.resolveFileURI();
            if (uri == null) {
                throw new ConfigurationRuntimeException("Unable to determine file to monitor");
            }
            return fsManager.resolveFile(uri);
        }
        catch (FileSystemException fse) {
            String msg = "Unable to monitor " + this.getFileHandler().getURL().toString();
            this.log.error(msg);
            throw new ConfigurationRuntimeException(msg, fse);
        }
    }

    protected String resolveFileURI() {
        FileSystem fs = this.getFileHandler().getFileSystem();
        return fs.getPath(null, this.getFileHandler().getURL(), this.getFileHandler().getBasePath(), this.getFileHandler().getFileName());
    }
}

