/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.api.patch;

import de.ponton.application.update.api.content.AddFile;
import de.ponton.application.update.api.content.AddFolder;
import de.ponton.application.update.api.content.DeleteFile;
import de.ponton.application.update.api.content.DeleteFolder;
import de.ponton.application.update.api.content.IDiffEntry;
import de.ponton.application.update.api.content.ItemState;
import de.ponton.application.update.api.content.ItemType;
import de.ponton.application.update.api.content.ModifyFile;
import de.ponton.application.update.api.jar.SingleJarVerifier;
import de.ponton.application.update.api.wrapperconf.WrapperConf;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import shaded.javax.activation.DataSource;
import shaded.javax.activation.URLDataSource;
import shaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import shaded.org.apache.commons.compress.archivers.zip.ZipFile;
import shaded.org.apache.commons.configuration2.ex.ConfigurationException;

public class PatchReader {
    public static final String DIST_PREFIX = "dist/";
    public static final String DIFF_FILE_PATH = "META-INF/diff";
    public static final String PATCH_WRAPPER_CONF_FILE_PATH = "META-INF/wrapper.conf";
    private final File patchJarFile;
    private final List<X509Certificate> trustRootCAs;

    public PatchReader(File patchJarFile, List<X509Certificate> trustRootCAs) {
        Objects.requireNonNull(patchJarFile, "Patch jar file is requiered");
        Objects.requireNonNull(patchJarFile, "Trust root CA list is requiered");
        this.patchJarFile = patchJarFile;
        this.trustRootCAs = trustRootCAs;
    }

    public void verifySignedJar() throws IOException, SecurityException {
        SingleJarVerifier.verify(this.patchJarFile, this.trustRootCAs);
    }

    /*
     * Exception decompiling
     */
    public WrapperConf getWrapperConf() throws IOException, ConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public SortedSet<IDiffEntry> getAllDiffs() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SortedSet<IDiffEntry> getDeleteDiffs() throws IOException {
        SortedSet<IDiffEntry> allDiffEntries = this.getAllDiffs();
        TreeSet<IDiffEntry> deleteDiffEntries = new TreeSet<IDiffEntry>(new Comparator<IDiffEntry>(){

            @Override
            public int compare(IDiffEntry leftDiffEntry, IDiffEntry rightDiffEntry) {
                return rightDiffEntry.compareTo(leftDiffEntry);
            }
        });
        for (IDiffEntry diffEntry : allDiffEntries) {
            if (!ItemState.DELETE.equals((Object)diffEntry.getItemState())) continue;
            deleteDiffEntries.add(diffEntry);
        }
        return deleteDiffEntries;
    }

    public SortedSet<IDiffEntry> getModifyDiffs() throws IOException {
        SortedSet<IDiffEntry> allDiffEntries = this.getAllDiffs();
        TreeSet<IDiffEntry> modifyDiffEntries = new TreeSet<IDiffEntry>();
        for (IDiffEntry diffEntry : allDiffEntries) {
            switch (diffEntry.getItemState()) {
                case ADD: 
                case MODIFY: {
                    modifyDiffEntries.add(diffEntry);
                    break;
                }
            }
        }
        return modifyDiffEntries;
    }

    private SortedSet<IDiffEntry> readAppDiff(InputStream jarEntryInputStream, ZipFile zipFile) throws IOException {
        TreeSet<IDiffEntry> diffs = new TreeSet<IDiffEntry>();
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(jarEntryInputStream, "UTF-8"));){
            String line = null;
            while ((line = lineNumberReader.readLine()) != null) {
                URLDataSource content;
                int unixMode;
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                ItemState itemState = ItemState.valueOf(tokenizer.nextToken());
                ItemType itemType = ItemType.valueOf(tokenizer.nextToken());
                Path relativePath = new File(tokenizer.nextToken()).toPath();
                if (ItemType.FILE.equals((Object)itemType) && (ItemState.ADD.equals((Object)itemState) || ItemState.MODIFY.equals((Object)itemState))) {
                    ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(DIST_PREFIX + this.getNormalizedPath(relativePath));
                    unixMode = this.getUnixModeFor(zipArchiveEntry);
                    content = new URLDataSource(new URL("jar:" + this.patchJarFile.toURI().toURL().toExternalForm() + "!/" + DIST_PREFIX + this.getNormalizedPath(relativePath)));
                } else {
                    content = null;
                    unixMode = 493;
                }
                diffs.add(this.createDiffEntry(itemState, itemType, relativePath, content, unixMode));
            }
        }
        return diffs;
    }

    private int getUnixModeFor(ZipArchiveEntry zipArchiveEntry) {
        int unixMode = zipArchiveEntry.getUnixMode();
        if (unixMode > 0) {
            return unixMode;
        }
        return 493;
    }

    private String getNormalizedPath(Path path) {
        return path.toString().replaceAll("\\\\", "/");
    }

    private IDiffEntry createDiffEntry(ItemState itemState, ItemType itemType, Path relativePath, DataSource content, int unixMode) {
        switch (itemType) {
            case FOLDER: {
                return this.createDiffEntryForFolder(itemState, relativePath);
            }
            case FILE: {
                return this.createDiffEntryForFile(itemState, relativePath, content, unixMode);
            }
        }
        throw new IllegalArgumentException("Not supported item type found: " + itemType.toString());
    }

    private IDiffEntry createDiffEntryForFile(ItemState itemState, Path relativePath, DataSource content, int unixMode) {
        switch (itemState) {
            case ADD: {
                return new AddFile(relativePath, content, unixMode);
            }
            case MODIFY: {
                return new ModifyFile(relativePath, content, unixMode);
            }
            case DELETE: {
                return new DeleteFile(relativePath);
            }
        }
        throw new IllegalArgumentException("Not supported item state found: " + itemState.toString());
    }

    private IDiffEntry createDiffEntryForFolder(ItemState itemState, Path relativePath) {
        switch (itemState) {
            case ADD: {
                return new AddFolder(relativePath);
            }
            case DELETE: {
                return new DeleteFolder(relativePath);
            }
        }
        throw new IllegalArgumentException("Not supported item state found: " + itemState.toString());
    }
}

