/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.api.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class SingleJarVerifier {
    public static void verify(File jarFile, List<X509Certificate> trustedRootCAs) throws IOException {
        Objects.requireNonNull(jarFile, "Jar file is required.");
        try (JarFile javaJarFile = new JarFile(jarFile);){
            Manifest manifest = javaJarFile.getManifest();
            if (Objects.isNull(manifest)) {
                throw new SecurityException("The jar does not contain a manifest.");
            }
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> jarEntries = javaJarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || SingleJarVerifier.hasToBeIgnored(jarEntry.getName())) continue;
                try (InputStream jarEntryInputStream = javaJarFile.getInputStream(jarEntry);){
                    while (jarEntryInputStream.read(buffer) != -1) {
                    }
                }
                SingleJarVerifier.checkCertificateFor(jarEntry, trustedRootCAs);
            }
        }
    }

    private static boolean hasToBeIgnored(String path) {
        return path.startsWith("META-INF/") && (path.endsWith(".RSA") || path.endsWith(".SF") || path.endsWith("MANIFEST.MF"));
    }

    private static void checkCertificateFor(JarEntry jarEntry, List<X509Certificate> trustedRootCAs) {
        Certificate[] usedCertificates = jarEntry.getCertificates();
        if (usedCertificates == null || usedCertificates.length == 0) {
            throw new SecurityException("The jar contains unsinged file: " + jarEntry.getName());
        }
        List<X509Certificate> rootCAs = SingleJarVerifier.determineRootCAs(usedCertificates);
        if (!SingleJarVerifier.containsTrustedCA(rootCAs, trustedRootCAs)) {
            throw new SecurityException("The jar is signed by an untrusted signer.");
        }
    }

    private static boolean containsTrustedCA(List<X509Certificate> rootCAs, List<X509Certificate> trustedRootCAs) {
        for (X509Certificate rootCA : rootCAs) {
            if (!trustedRootCAs.contains(rootCA)) continue;
            return true;
        }
        return false;
    }

    private static List<X509Certificate> determineRootCAs(Certificate[] usedCertificates) {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (Certificate certificate : usedCertificates) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            if (!x509Certificate.getSubjectX500Principal().equals(x509Certificate.getIssuerX500Principal())) continue;
            result.add(x509Certificate);
        }
        return result;
    }
}

