/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.util;

import de.pontonconsulting.common.encoding.Base64Decoder;
import de.pontonconsulting.common.encoding.Base64Encoder;

public class CommonFormat {
    public static String encodeBase64(String header, byte[] unencoded, String footer) {
        return CommonFormat.encodeBase64(header, unencoded, 64, footer);
    }

    public static String encodeBase64(String header, byte[] unencoded, int lineLength, String footer) {
        String content = Base64Encoder.encode((byte[])unencoded, (int)lineLength);
        if (content != null) {
            content = header + content + footer;
        }
        return content;
    }

    public static byte[] decodeBase64(String header, String encoded, String footer) {
        String content = CommonFormat.extractContent(header, encoded, footer);
        content = content.replaceAll(" ", "");
        content = content.replaceAll("\t", "");
        content = content.replaceAll("\r", "");
        content = content.replaceAll("\n", "");
        return Base64Decoder.decode((String)content);
    }

    private static String extractContent(String header, String encoded, String footer) {
        String newHeader = header.trim();
        String newFooter = footer.trim();
        int headerIndex = -1;
        int footerIndex = -1;
        headerIndex = encoded.indexOf(newHeader);
        if (headerIndex > -1) {
            footerIndex = encoded.indexOf(newFooter, headerIndex);
        }
        if (footerIndex > -1) {
            return encoded.substring(headerIndex + newHeader.length(), footerIndex);
        }
        return encoded;
    }
}

