/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import de.pontonconsulting.security.CertificateRequest;
import de.pontonconsulting.security.Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateCreator {
    private static final String CERTIFICATE_TYPE = "X.509";

    public static X509Certificate signRequest(CertificateRequest certRequest, X509Certificate caCert, PrivateKey caKey, Date notBefore, Date notAfter, Extension[] certExtensions) throws SecurityException, GeneralSecurityException, CertIOException, OperatorCreationException {
        X500Name subjectName = certRequest.getSubject();
        X500Name issuerName = new X500Name(caCert.getSubjectDN().getName());
        BigInteger serialNumber = new BigInteger(30, new SecureRandom());
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, notBefore, notAfter, subjectName, certRequest.getPublicKey());
        for (int i = 0; i < certExtensions.length; ++i) {
            Extension extension = certExtensions[i];
            certificateBuilder.addExtension(new ASN1ObjectIdentifier(extension.getOID()), extension.getCritical(), (ASN1Encodable)new DERUTF8String(extension.getExtensionCommonFormat()));
        }
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider("BC").build(caKey);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(sigGen));
        return cert;
    }

    public static X509Certificate getCertificate(byte[] der) throws GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE, "BC");
        ByteArrayInputStream bais = new ByteArrayInputStream(der);
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static X509Certificate createSelfSignedCertificate(String issuer, PublicKey subjectPublicKey, Date notBefore, Date notAfter, PrivateKey issuerPrivateKey) throws GeneralSecurityException, CertIOException, OperatorCreationException {
        return CertificateCreator.createCertificate(issuer, null, subjectPublicKey, notBefore, notAfter, issuer, issuerPrivateKey);
    }

    public static X509Certificate createCertificate(String subject, Extension[] extensions, PublicKey subjectPublicKey, Date notBefore, Date notAfter, String issuer, PrivateKey issuerPrivateKey) throws GeneralSecurityException, CertIOException, OperatorCreationException {
        return CertificateCreator.createCertificate(subject, new BigInteger(30, new SecureRandom()), extensions, subjectPublicKey, notBefore, notAfter, issuer, issuerPrivateKey);
    }

    public static X509Certificate createCertificate(String subject, BigInteger serialNumber, Extension[] extensions, PublicKey subjectPublicKey, Date notBefore, Date notAfter, String issuer, PrivateKey issuerPrivateKey) throws GeneralSecurityException, CertIOException, OperatorCreationException {
        X500Name subjectName = new X500Name(subject);
        X500Name issuerName = new X500Name(issuer);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, notBefore, notAfter, subjectName, subjectPublicKey);
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                Extension extension = extensions[i];
                certificateBuilder.addExtension(new ASN1ObjectIdentifier(extension.getOID()), extension.getCritical(), (ASN1Encodable)new DERUTF8String(extension.getExtensionCommonFormat()));
            }
        }
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider("BC").build(issuerPrivateKey);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(sigGen));
        return cert;
    }

    public static KeyPair generateKeyPair() throws GeneralSecurityException {
        return CertificateCreator.generateKeyPair("RSA", 1024);
    }

    public static KeyPair generateKeyPair(String algorithm, int keysize) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm, "BC");
        kpg.initialize(keysize, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static String retrieveNameAttribute(String attribute, X500Name x500Principal) {
        String name = x500Principal.toString();
        return CertificateCreator.extractAttribute(attribute, name);
    }

    private static String extractAttribute(String attribute, String name) {
        int from = name.toLowerCase().indexOf(attribute + "=");
        if (from == -1) {
            return null;
        }
        int to = name.toLowerCase().indexOf(",", from += (attribute + "=").length());
        if (to == -1) {
            if (from == name.length()) {
                return null;
            }
            to = name.length();
        }
        return name.substring(from, to).trim();
    }

    public static String retrieveNameAttribute(String attribute, X500Principal subjectX500Principal) {
        String name = subjectX500Principal.getName("RFC1779");
        return CertificateCreator.extractAttribute(attribute, name);
    }

    public static PublicKey createPublicKey(SubjectPublicKeyInfo subjectPKInfo) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        DERBitString bStr = new DERBitString((ASN1Encodable)subjectPKInfo);
        X509EncodedKeySpec xspec = new X509EncodedKeySpec(bStr.getBytes());
        String algorithmId = subjectPKInfo.getAlgorithm().getAlgorithm().getId();
        KeyFactory factory = KeyFactory.getInstance(algorithmId, "BC");
        return factory.generatePublic(xspec);
    }
}

