/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.activation.AbstractModel;
import de.pontonconsulting.security.CertificateCreator;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.operator.OperatorCreationException;

public class ProductIdentification
extends AbstractModel {
    private PrivateKey _privateKey;

    public ProductIdentification(X509Certificate certificate, PrivateKey privateKey) {
        super(certificate);
        this._privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public static ProductIdentification createProductIdenfication(String issuer) throws GeneralSecurityException {
        KeyPair keyPair = CertificateCreator.generateKeyPair();
        Date notBefore = new Date(0L);
        Date notAfter = new Date(7289564400000L);
        try {
            X509Certificate cert = CertificateCreator.createSelfSignedCertificate(issuer, keyPair.getPublic(), notBefore, notAfter, keyPair.getPrivate());
            return new ProductIdentification(cert, keyPair.getPrivate());
        }
        catch (CertIOException e) {
            throw new GeneralSecurityException(e);
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public boolean isTrialVersion() {
        return true;
    }
}

