/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationRequest;
import de.pontonconsulting.activation.IProductStateChecker;
import de.pontonconsulting.activation.IRequestExtensionBuilder;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.activation.ProductIdentification;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public interface IActivationManager {
    public void validateLicense(License var1) throws ActivationException;

    public void validateProductIdentification() throws ActivationException;

    public void checkProductState() throws ActivationException;

    public void importProductIdentification(ProductIdentification var1) throws ActivationException;

    public void importActivation(IProductStateChecker var1, Activation var2) throws ActivationException;

    public void importLicense(X509Certificate var1) throws ActivationException;

    public void importLicense(License var1) throws ActivationException;

    public void deleteLicense();

    public void deleteActivation();

    public ProductIdentification getProductIdentification() throws ActivationException;

    public ActivationRequest generateActivationRequest(IRequestExtensionBuilder var1) throws ActivationException;

    public String getProductName();

    public String getProductVersion();

    public X509Certificate getProductIdentificationCert() throws ActivationException;

    public X509Certificate getActivationCert() throws ActivationException;

    public X509Certificate getLicenseCert() throws ActivationException;

    public X509Certificate getLicenseCA() throws ActivationException;

    public X509Certificate[] getCertificateChain(X509Certificate var1) throws ActivationException;

    public PrivateKey getProductIdentificationPK() throws ActivationException;

    public X500Principal getRequestSubject();

    public void storeActivationCert(X509Certificate var1) throws ActivationException;

    public void storeLicenseCert(X509Certificate var1) throws ActivationException;

    public void storeProductKey(PrivateKey var1, X509Certificate var2) throws ActivationException;
}

