/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.activation.AbstractModel;
import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationRequest;
import de.pontonconsulting.activation.IActivationManager;
import de.pontonconsulting.activation.IProductStateChecker;
import de.pontonconsulting.activation.IRequestExtensionBuilder;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.activation.ProductIdentification;
import de.pontonconsulting.security.Extension;
import de.pontonconsulting.security.GenericKeyStore;
import de.pontonconsulting.util.Utils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class ActivationManager
implements IActivationManager {
    @Override
    public void validateLicense(License license) throws ActivationException {
        try {
            GenericKeyStore.checkCertificate(license.getCertificate(), license.getCA());
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1026L, "license is not valid");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        try {
            this.checkCertDates(new X509Certificate[]{license.getCertificate()}, this.getReferenceDate());
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1031L, "license is out of date");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        try {
            this.checkCertificate(license.getCA());
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1014L, "license CA is not valid");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    @Override
    public void validateProductIdentification() throws ActivationException {
        try {
            this.checkCertificate(this.getProductIdentificationCert());
        }
        catch (ActivationException e) {
            ActivationException ae = new ActivationException(1025L, "product identification is not valid");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void validateActivationCert(X509Certificate cert) throws ActivationException {
        try {
            this.checkCertificate(cert);
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1024L, "activation is not valid");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void checkCertificate(X509Certificate cert) throws ActivationException {
        X509Certificate[] chain = this.getCertificateChain(cert);
        try {
            GenericKeyStore.checkCertificate(chain, this.getReferenceDate());
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1013L, "certificate is not valid");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void checkCertDates(X509Certificate[] certChain, Date referenceDate) throws CertificateException {
        for (int i = 0; i < certChain.length; ++i) {
            X509Certificate certificate = certChain[i];
            GenericKeyStore.checkValidity(certificate, referenceDate);
        }
    }

    @Override
    public void checkProductState() throws ActivationException {
        License license = this.getLicense();
        String activationRuleFlag = license.getActivationRuleFlag();
        if ("never".equals(activationRuleFlag)) {
            this.checkLicense(license);
        } else {
            Activation activation = this.getActivation();
            this.checkActivationAndInstalledLicense(activation);
        }
    }

    private void checkActivationAndInstalledLicense(Activation activation) throws ActivationException {
        this.checkActivation(activation);
        if (activation.isFullVersion()) {
            BigInteger licenseID = activation.getLicenseSerialNumber();
            License license = this.getLicense();
            this.checkLicense(license);
            if (licenseID == null || !licenseID.equals(license.getSerialNumber())) {
                ActivationException ae = new ActivationException(1018L, "activation for the installed license is wrong");
                throw ae;
            }
        } else {
            License license = this.getLicense();
            if (license.isFullVersion()) {
                ActivationException ae = new ActivationException(1018L, "activation for the installed license is wrong");
                throw ae;
            }
        }
    }

    private void checkActivation(Activation activation) throws ActivationException {
        this.doCheckActivation(activation);
        this.validateActivationCert(activation.getCertificate());
        this.checkProductCompatibilityFor(activation);
        PublicKey productPK = this.getProductIdentificationCert().getPublicKey();
        PublicKey activationPK = activation.getPublicKey();
        if (!activationPK.equals(productPK)) {
            ActivationException ae = new ActivationException(1029L, "activation for this product identification is wrong");
            throw ae;
        }
    }

    protected void doCheckActivation(Activation activation) throws ActivationException {
    }

    private void checkLicense(License license) throws ActivationException {
        try {
            this.validateLicense(license);
            this.checkProductCompatibilityFor(license);
        }
        catch (ActivationException a) {
            this.deleteLicense();
            this.deleteActivation();
            throw a;
        }
    }

    private void checkProductCompatibilityFor(Activation activation) throws ActivationException {
        try {
            this.checkProductName(activation);
            this.checkProductVersion(activation);
        }
        catch (ActivationException e) {
            ActivationException ae = new ActivationException(1027L, "activation is not for this product or product version");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void checkProductCompatibilityFor(License license) throws ActivationException {
        try {
            this.checkProductName(license);
            this.checkPontonXPHighestVersion(license);
        }
        catch (ActivationException e) {
            ActivationException ae = new ActivationException(1028L, "license is not for this product");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void checkPontonXPHighestVersion(License license) throws ActivationException {
        String pontonXPHighestVersion;
        if ("never".equals(license.getActivationRuleFlag()) && (pontonXPHighestVersion = license.getPontonXPHighestVersion()) != null && Utils.compareProductVersions(pontonXPHighestVersion, this.getProductVersion()) < 0) {
            ActivationException ae = new ActivationException(1016L, "product with this product version is not supported");
            throw ae;
        }
    }

    private void checkProductName(AbstractModel model) throws ActivationException {
        String modelProductName = model.getProductName();
        if (modelProductName != null && !modelProductName.equals(this.getProductName())) {
            ActivationException ae = new ActivationException(1015L, "product with this product name is not supported");
            throw ae;
        }
    }

    private void checkProductVersion(AbstractModel model) throws ActivationException {
        String modelProductVersion = model.getProductVersion();
        if (modelProductVersion != null && !modelProductVersion.equals(this.getProductVersion())) {
            ActivationException ae = new ActivationException(1016L, "product with this product version is not supported");
            throw ae;
        }
    }

    @Override
    public void importProductIdentification(ProductIdentification productIdentification) throws ActivationException {
        this.storeProductKey(productIdentification.getPrivateKey(), productIdentification.getCertificate());
    }

    @Override
    public void importActivation(IProductStateChecker productStateChecker, Activation activation) throws ActivationException {
        if (productStateChecker == null) {
            throw new ActivationException(1020L, "Product state checker reference was null.");
        }
        if (activation == null) {
            throw new ActivationException(1020L, "Activation reference was null.");
        }
        this.checkActivationAndInstalledLicense(activation);
        productStateChecker.checkProductState(activation);
        this.storeActivationCert(activation.getCertificate());
    }

    @Override
    public void importLicense(X509Certificate licenseCert) throws ActivationException {
        X509Certificate ca = this.getLicenseCA();
        this.importLicense(new License(licenseCert, ca));
    }

    @Override
    public void importLicense(License license) throws ActivationException {
        this.validateLicense(license);
        this.checkProductCompatibilityFor(license);
        this.storeLicenseCert(license.getCertificate());
    }

    public Activation getActivation() throws ActivationException {
        X509Certificate cert = this.getActivationCert();
        return new Activation(cert);
    }

    public License getLicense() throws ActivationException {
        X509Certificate cert = this.getLicenseCert();
        return new License(cert, this.getLicenseCA());
    }

    @Override
    public ProductIdentification getProductIdentification() throws ActivationException {
        X509Certificate cert = this.getProductIdentificationCert();
        PrivateKey pk = this.getProductIdentificationPK();
        return new ProductIdentification(cert, pk);
    }

    @Override
    public ActivationRequest generateActivationRequest(IRequestExtensionBuilder requestExtensionBuilder) throws ActivationException {
        Extension[] extensions = this.buildAllRequestExtensions(requestExtensionBuilder.buildRequestExtensions());
        X500Principal subject = this.getRequestSubject();
        ProductIdentification productIdent = this.getProductIdentification();
        License license = this.getLicense();
        return new ActivationRequest(subject, extensions, productIdent, license);
    }

    @Override
    public abstract void deleteLicense();

    @Override
    public abstract void deleteActivation();

    @Override
    public abstract X509Certificate getProductIdentificationCert() throws ActivationException;

    @Override
    public abstract PrivateKey getProductIdentificationPK() throws ActivationException;

    @Override
    public abstract X509Certificate getLicenseCert() throws ActivationException;

    @Override
    public abstract X509Certificate getActivationCert() throws ActivationException;

    @Override
    public abstract X509Certificate getLicenseCA() throws ActivationException;

    @Override
    public abstract X509Certificate[] getCertificateChain(X509Certificate var1) throws ActivationException;

    protected abstract Date getReferenceDate();

    private Extension[] buildAllRequestExtensions(Extension[] extensions) {
        Extension[] newExtensions;
        Extension productName = new Extension("1.3.6.1.4.1.14136.1.1", new String[]{this.getProductName()});
        Extension productVersion = new Extension("1.3.6.1.4.1.14136.1.2", new String[]{this.getProductVersion()});
        if (extensions == null) {
            newExtensions = new Extension[2];
        } else {
            newExtensions = new Extension[extensions.length + 2];
            for (int i = 2; i < newExtensions.length; ++i) {
                newExtensions[i] = extensions[i - 2];
            }
        }
        newExtensions[0] = productName;
        newExtensions[1] = productVersion;
        return newExtensions;
    }
}

