/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.activation.AbstractModel;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.security.ASN1Security;
import de.pontonconsulting.security.CertificateCreator;
import de.pontonconsulting.util.CommonFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.cms.CMSException;

public class Activation
extends AbstractModel {
    public static final String ACTIVATION_HEADER = "-----BEGIN ACTIVATION-----\n";
    public static final String ACTIVATION_FOOTER = "\n-----END ACTIVATION-----\n";

    public Activation(X509Certificate certificate) {
        super(certificate);
    }

    public Activation(String encodedActivation, PrivateKey key) throws ActivationException {
        super(Activation.encodeCertificate(encodedActivation, key));
    }

    private static X509Certificate encodeCertificate(String encodedActivation, PrivateKey key) throws ActivationException {
        try {
            byte[] encodedDER = CommonFormat.decodeBase64(ACTIVATION_HEADER, encodedActivation, ACTIVATION_FOOTER);
            byte[] der = ASN1Security.decrypt(encodedDER, key);
            return Activation.buildCertificate(der);
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1000L, "could not read activation");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public Activation(byte[] der) throws ActivationException {
        super(Activation.buildCertificate(der));
    }

    private static X509Certificate buildCertificate(byte[] der) throws ActivationException {
        try {
            return CertificateCreator.getCertificate(der);
        }
        catch (GeneralSecurityException e) {
            ActivationException ae = new ActivationException(1001L, "could not build activation certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    @Override
    public boolean isTrialVersion() {
        BigInteger license = this.getLicenseSerialNumber();
        return license == null;
    }

    public BigInteger getLicenseSerialNumber() {
        String licenseID = this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.3");
        if (licenseID != null) {
            try {
                return new BigInteger(licenseID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBase64Encoded() throws ActivationException {
        return CommonFormat.encodeBase64(ACTIVATION_HEADER, this.getEncodedDER(), ACTIVATION_FOOTER);
    }

    public byte[] getEncodedDER() throws ActivationException {
        X509Certificate encodeCert = this.getCertificate();
        if (encodeCert == null) {
            throw new ActivationException(1002L, "could not find activation certificate");
        }
        try {
            return ASN1Security.encrypt(this.getCertificate().getEncoded(), encodeCert);
        }
        catch (IOException e) {
            ActivationException ae = new ActivationException(1003L, "could not encode activation certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        catch (GeneralSecurityException e) {
            ActivationException ae = new ActivationException(1003L, "could not encode activation certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        catch (CMSException e) {
            ActivationException ae = new ActivationException(1003L, "could not encode activation certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public String getActivationRuleFlag() {
        if (this.getCertificate() != null) {
            return this.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.6");
        }
        return null;
    }
}

