/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.KeyAgreement;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.utils.ConcatKDFGenerator;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EllipticCurveSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EllipticCurveSupport.class);
    private static EllipticCurveSupport INSTANCE = new EllipticCurveSupport();
    private String providerId = null;
    private String PROVIDER_ID_BOUNCY_CASTLE = "BC";
    private String KEY_AGREEMENT_ALGORITHM_ID = "ECDH";

    private EllipticCurveSupport() {
    }

    public byte[] getSharedSecret(PrivateKey ephermalPrivateKey, PublicKey receiverPublicKey) throws NoSuchAlgorithmException {
        try {
            KeyAgreement keyAgreement = this.getKeyAgreement();
            keyAgreement.init(ephermalPrivateKey);
            keyAgreement.doPhase(receiverPublicKey, true);
            return keyAgreement.generateSecret();
        }
        catch (Exception e) {
            if (this.providerId == null) {
                LOG.debug("Required KeyAgreement not support by default SecurityProvider ({}). Retry with BouncyCastle-Provider...", (Object)e.getMessage());
                this.providerId = this.PROVIDER_ID_BOUNCY_CASTLE;
                return this.getSharedSecret(ephermalPrivateKey, receiverPublicKey);
            }
            throw new NoSuchAlgorithmException(e);
        }
    }

    public KeyPair generateOneTimeECKeyPair(ECPublicKey receiverPublicKey) throws NoSuchAlgorithmException, NoSuchProviderException {
        ECParameterSpec ecSpec = receiverPublicKey.getParams();
        try {
            KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator();
            keyPairGenerator.initialize(ecSpec, new SecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            if (this.providerId == null) {
                LOG.debug("Elliptic curve {} not support by default SecurityProvider. Retry with BouncyCastle-Provider...", (Object)ecSpec.getCurve().toString());
                this.providerId = this.PROVIDER_ID_BOUNCY_CASTLE;
                return this.generateOneTimeECKeyPair(receiverPublicKey);
            }
            throw new NoSuchAlgorithmException(e);
        }
    }

    public byte[] getWrappedKeyBytes(ConcatKDFParameters concatKDFParameters, byte[] sharedSecret) throws KeyResolverException, NoSuchAlgorithmException {
        String digestAlgorithmUri = JCEMapper.translateURItoJCEID(concatKDFParameters.getDigestMethod());
        ConcatKDFGenerator concatKDFGenerator = new ConcatKDFGenerator(MessageDigest.getInstance(digestAlgorithmUri));
        concatKDFGenerator.init(sharedSecret, concatKDFParameters);
        int secretKeyLength = JCEMapper.getKeyLengthFromURI(concatKDFParameters.getEncryptionMethod()) / 8;
        byte[] wrappedKeyBytes = new byte[secretKeyLength];
        concatKDFGenerator.generateBytes(wrappedKeyBytes, 0, secretKeyLength);
        return wrappedKeyBytes;
    }

    private KeyAgreement getKeyAgreement() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.providerId == null ? KeyAgreement.getInstance(this.KEY_AGREEMENT_ALGORITHM_ID) : KeyAgreement.getInstance(this.KEY_AGREEMENT_ALGORITHM_ID, this.providerId);
    }

    private KeyPairGenerator getKeyPairGenerator() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.providerId == null ? KeyPairGenerator.getInstance(this.KEY_AGREEMENT_ALGORITHM_ID) : KeyPairGenerator.getInstance(this.KEY_AGREEMENT_ALGORITHM_ID, this.providerId);
    }

    public static EllipticCurveSupport getInstance() {
        return INSTANCE;
    }
}

