/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyDerivationMethod
extends ElementProxy
implements KeyInfoContent {
    public KeyDerivationMethod(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public KeyDerivationMethod(Document doc, ConcatKDFParameters concatKDFParameters) throws XMLSecurityException {
        super(doc);
        this.setLocalAttribute("Algorithm", "http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Element concatKDFparamsElement = XMLUtils.createElementInEncryption11Space(this.getDocument(), "ConcatKDFParams");
        concatKDFparamsElement.setAttributeNS(null, "AlgorithmID", concatKDFParameters.getAlgorithmId());
        concatKDFparamsElement.setAttributeNS(null, "PartyUInfo", concatKDFParameters.getPartyUInfo());
        concatKDFparamsElement.setAttributeNS(null, "PartyVInfo", concatKDFParameters.getPartyVInfo());
        if (concatKDFParameters.getSuppPrivInfo() != null) {
            concatKDFparamsElement.setAttributeNS(null, "SuppPrivInfo", concatKDFParameters.getSuppPubInfo());
        }
        if (concatKDFParameters.getSuppPubInfo() != null) {
            concatKDFparamsElement.setAttributeNS(null, "SuppPubInfo", concatKDFParameters.getSuppPubInfo());
        }
        this.appendSelf(concatKDFparamsElement);
        if (concatKDFParameters.getDigestMethod() != null) {
            Element digestMethodElement = XMLUtils.createElementInSignatureSpace(this.getDocument(), "DigestMethod");
            digestMethodElement.setAttributeNS(null, "Algorithm", concatKDFParameters.getDigestMethod());
            concatKDFparamsElement.appendChild(digestMethodElement);
            this.addReturnToSelf();
        }
    }

    public String getAlgorithm() {
        return this.getLocalAttribute("Algorithm");
    }

    public String getDigestMethodAlgorithm() {
        Element digestMethodElement;
        Element concatKDFparamsElement = this.getConcatKDFParamElement();
        if (concatKDFparamsElement != null && (digestMethodElement = XMLUtils.selectDsNode(concatKDFparamsElement.getFirstChild(), "DigestMethod", 0)) != null) {
            return digestMethodElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public String getConKDFPartyUInfo() {
        Element concatKDFparamsElement = this.getConcatKDFParamElement();
        if (concatKDFparamsElement != null) {
            return concatKDFparamsElement.getAttributeNS(null, "PartyUInfo");
        }
        return null;
    }

    public String getConKDFPartyVInfo() {
        Element concatKDFparamsElement = this.getConcatKDFParamElement();
        if (concatKDFparamsElement != null) {
            return concatKDFparamsElement.getAttributeNS(null, "PartyVInfo");
        }
        return null;
    }

    private Element getConcatKDFParamElement() {
        return XMLUtils.selectXenc11Node(this.getFirstChild(), "ConcatKDFParams", 0);
    }

    @Override
    public String getBaseLocalName() {
        return "KeyDerivationMethod";
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2009/xmlenc11#";
    }
}

