/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuthorizationIdentityRequestControl
extends Control {
    @NotNull
    public static final String AUTHORIZATION_IDENTITY_REQUEST_OID = "2.16.840.1.113730.3.4.16";
    private static final long serialVersionUID = -4059607155175828138L;

    public AuthorizationIdentityRequestControl() {
        super(AUTHORIZATION_IDENTITY_REQUEST_OID, false, null);
    }

    public AuthorizationIdentityRequestControl(boolean isCritical) {
        super(AUTHORIZATION_IDENTITY_REQUEST_OID, isCritical, null);
    }

    public AuthorizationIdentityRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AUTHZID_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_AUTHZID_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", AUTHORIZATION_IDENTITY_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_AUTHZID_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static AuthorizationIdentityRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new AuthorizationIdentityRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AuthorizationIdentityRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

