/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MultipartBodyWriter;
import org.apache.axiom.om.OMOutputFormat;

public class OMMultipartWriter {
    private final OMOutputFormat format;
    private final MultipartBodyWriter writer;
    private final boolean useCTEBase64;
    private final String rootPartContentType;

    public OMMultipartWriter(OutputStream out, OMOutputFormat format) {
        this(out, format, format != null && Boolean.TRUE.equals(format.getProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments")));
    }

    public OMMultipartWriter(OutputStream out, OMOutputFormat format, boolean base64) {
        this.format = format;
        this.writer = new MultipartBodyWriter(out, format.getMimeBoundary());
        this.useCTEBase64 = base64;
        String soapContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
        this.rootPartContentType = format.isOptimized() ? "application/xop+xml; charset=" + format.getCharSetEncoding() + "; type=\"" + soapContentType + "\"" : soapContentType + "; charset=" + format.getCharSetEncoding();
    }

    private String getContentTransferEncoding() {
        if (this.useCTEBase64) {
            return "base64";
        }
        return "binary";
    }

    public String getRootPartContentType() {
        return this.rootPartContentType;
    }

    public OutputStream writeRootPart() throws IOException {
        return this.writer.writePart(this.rootPartContentType, this.getContentTransferEncoding(), this.format.getRootContentId(), null);
    }

    public OutputStream writePart(String contentType, String contentID) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(), contentID, null);
    }

    public OutputStream writePart(String contentType, String contentID, List<Header> extraHeaders) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(), contentID, extraHeaders);
    }

    public void writePart(DataHandler dataHandler, String contentID, List<Header> extraHeaders) throws IOException {
        String contentTransferEncoding = null;
        if (dataHandler instanceof ConfigurableDataHandler) {
            contentTransferEncoding = ((ConfigurableDataHandler)dataHandler).getTransferEncoding();
        }
        if (contentTransferEncoding == null) {
            contentTransferEncoding = this.getContentTransferEncoding();
        }
        this.writer.writePart(dataHandler, contentTransferEncoding, contentID, extraHeaders);
    }

    public void writePart(DataHandler dataHandler, String contentID) throws IOException {
        this.writePart(dataHandler, contentID, null);
    }

    public void complete() throws IOException {
        this.writer.complete();
    }
}

