/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class SAXPath {
    private String _elementNeeded;
    private String _attributeNeeded;
    private int _levelNeeded;
    private final String _xpath;
    private final ArrayList _values = new ArrayList();
    private boolean _found;
    private boolean _elementFound;
    private final boolean _repeatable;

    public SAXPath(String xpath, boolean repeatable) {
        this._repeatable = repeatable;
        this._xpath = xpath;
        StringTokenizer tokens = new StringTokenizer(this._xpath, "/");
        this._levelNeeded = tokens.countTokens();
        int offset = xpath.indexOf(64);
        if (offset == -1) {
            this._elementNeeded = xpath;
        } else {
            this._elementNeeded = xpath.substring(0, offset - 1);
            this._attributeNeeded = xpath.substring(offset + 1);
            --this._levelNeeded;
        }
    }

    public void startElement(String localName, int xpathLevel, String currentXpath, Attributes attributes) {
        if ((!this._found || this._repeatable) && this._elementNeeded.equals(currentXpath)) {
            if (this._attributeNeeded != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!this._attributeNeeded.equals(attributes.getQName(i))) continue;
                    this._values.add(attributes.getValue(i));
                    this._found = true;
                    break;
                }
            } else {
                this._elementFound = true;
            }
        }
    }

    public boolean endElement() {
        if (this._elementFound) {
            this._elementFound = false;
            this._found = true;
            if (this._values.isEmpty()) {
                this._values.add("");
            }
            return true;
        }
        return false;
    }

    public boolean handleText(String text) {
        boolean result = false;
        if (this._elementFound) {
            if (text != null) {
                this._values.add(text.trim());
            }
            this._elementFound = false;
            this._found = true;
        }
        return false;
    }

    public String getValue() {
        if (this._values.size() == 0) {
            return null;
        }
        if (this._values.size() == 1) {
            return (String)this._values.get(0);
        }
        return this._values.toString();
    }

    public String getValue(int i) {
        return (String)this._values.get(i);
    }

    public int getValueCount() {
        return this._values.size();
    }

    public String getXPath() {
        return this._xpath;
    }

    public boolean isFound() {
        return this._found;
    }

    public void reset() {
        this._found = false;
        this._elementFound = false;
        this._values.clear();
    }
}

