/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public abstract class FileUtils {
    private static final int SIXTYFOUR_KB = 65536;
    private static final int ONE_MB = 0x100000;

    public static boolean copy(String source, String destination) throws IOException {
        File src = new File(source);
        File dest = new File(destination);
        return FileUtils.copy(src, dest);
    }

    public static boolean copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            File[] subFile = source.listFiles();
            for (int i = 0; i < subFile.length; ++i) {
                FileUtils.copy(subFile[i], new File(destination, source.getName()));
            }
        } else {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            int length = -1;
            byte[] buffer = null;
            buffer = in.available() >= 0x100000 ? new byte[0x100000] : new byte[65536];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            in.close();
            out.close();
        }
        return true;
    }

    public static boolean move(File source, File destination) throws IOException {
        boolean resultOk = false;
        if (destination.equals(source)) {
            resultOk = true;
        } else if (source.isDirectory()) {
            File destFolder = new File(destination, source.getName());
            resultOk = source.renameTo(destFolder);
            if (!resultOk) {
                destFolder.mkdirs();
                File[] files = source.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    resultOk = FileUtils.copy(files[i], destFolder);
                    files[i].delete();
                }
                source.delete();
            }
        } else {
            resultOk = !destination.isDirectory() ? source.renameTo(destination) : source.renameTo(new File(destination, source.getName()));
            if (!resultOk) {
                boolean copyOk = FileUtils.copy(source, destination);
                boolean deleteOk = source.delete();
                resultOk = copyOk && deleteOk;
            }
        }
        return resultOk;
    }

    public static boolean move(String source, String destination) throws IOException {
        File src = new File(source);
        File dest = new File(destination);
        return FileUtils.move(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[16384];
        try (FileInputStream in = new FileInputStream(file);){
            int length = 0;
            while ((length = in.read(buffer)) != -1) {
                crc32.update(buffer, 0, length);
            }
        }
        return crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigest(File file) throws IOException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] buffer = new byte[16384];
            try (FileInputStream in = new FileInputStream(file);){
                int length = 0;
                while ((length = in.read(buffer)) != -1) {
                    md.update(buffer, 0, length);
                }
                digest = md.digest();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return digest;
    }

    public static boolean compareDigests(byte[] d1, byte[] d2) {
        try {
            MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return MessageDigest.isEqual(d1, d2);
    }
}

