/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunication;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunicationFactory;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class MessengerCommunicationFactory
implements IMessengerCommunicationFactory {
    private static IMessengerCommunicationFactory _instance;
    private final IMessengerCommunication _directCommunication;

    public MessengerCommunicationFactory(IMessengerCommunication directCommunication) {
        this._directCommunication = directCommunication;
        _instance = this;
    }

    private MessengerCommunicationFactory() {
        this._directCommunication = null;
    }

    public static synchronized IMessengerCommunicationFactory getInstance() {
        if (_instance == null) {
            _instance = new MessengerCommunicationFactory();
        }
        return _instance;
    }

    @Override
    public IMessengerCommunication getMessengerConnection(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, String logCategory, int processingTimeout, int serverPort) throws AdapterException, IOException {
        return this.getMessengerConnection(endAdapter, messengerHost, messengerPort, messengerPath, logCategory, processingTimeout, serverPort, null);
    }

    @Override
    public IMessengerCommunication getMessengerConnection(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, String logCategory, int processingTimeout, int serverPort, String adapterIP) throws AdapterException, IOException {
        if (this.usingDirectCommunication()) {
            return this._directCommunication;
        }
        File work = endAdapter.getWorkFolder();
        if (work == null) {
            throw new AdapterException("The adapters work folder is not set!");
        }
        if (!work.isDirectory()) {
            throw new AdapterException("The adapters work folder does not exist, or is not a directory: " + work.getAbsolutePath());
        }
        return this.createHttpMessengerCommunication(endAdapter, messengerHost, messengerPort, messengerPath, logCategory, processingTimeout, serverPort, adapterIP);
    }

    private IMessengerCommunication createHttpMessengerCommunication(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, String logCategory, int processingTimeout, int serverPort, String adapterIP) {
        IMessengerCommunication communication = null;
        try {
            Class<?> c = Class.forName("de.pontonconsulting.xmlpipe.adapter.HttpMessengerCommunication", false, Thread.currentThread().getContextClassLoader());
            Constructor<?> ctor = c.getConstructor(ISpecificAdapter.class, String.class, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, String.class);
            communication = (IMessengerCommunication)ctor.newInstance(endAdapter, messengerHost, messengerPort, messengerPath, logCategory, processingTimeout, serverPort, adapterIP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return communication;
    }

    @Override
    public boolean usingDirectCommunication() {
        return this._directCommunication != null;
    }
}

