/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.resolvers;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.dom.resolvers.X509CertFromCryptoResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PrivateKeyFromCryptoResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(PrivateKeyFromCryptoResolver.class);
    private final Crypto crypto;
    private final CallbackHandler callbackHandler;
    private final X509CertFromCryptoResolver x509CertResolver;

    public PrivateKeyFromCryptoResolver(Crypto crypto, CallbackHandler callbackHandler) {
        this.crypto = crypto;
        this.callbackHandler = callbackHandler;
        this.x509CertResolver = new X509CertFromCryptoResolver(crypto);
    }

    protected boolean engineCanResolve(Element element, String baseURI, StorageResolver storage) {
        return XMLUtils.elementIsInSignatureSpace((Element)element, (String)"X509Data") || XMLUtils.elementIsInSignatureSpace((Element)element, (String)"KeyName");
    }

    protected PublicKey engineResolvePublicKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) {
        return null;
    }

    protected X509Certificate engineResolveX509Certificate(Element element, String baseURI, StorageResolver storage, boolean secureValidation) {
        return null;
    }

    protected SecretKey engineResolveSecretKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) {
        return null;
    }

    protected PrivateKey engineResolvePrivateKey(Element element, String baseURI, StorageResolver storage, boolean secureValidation) {
        try {
            if (XMLUtils.elementIsInSignatureSpace((Element)element, (String)"X509Data")) {
                X509Certificate[] certs = this.x509CertResolver.resolveX509Certificates(element);
                if (certs != null && certs.length > 0) {
                    return this.crypto.getPrivateKey(certs[0], this.callbackHandler);
                }
            } else if (XMLUtils.elementIsInSignatureSpace((Element)element, (String)"KeyName")) {
                LOG.debug("Can I resolve KeyName?");
                String keyName = element.getFirstChild().getNodeValue();
                WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 1);
                this.callbackHandler.handle(new Callback[]{pwCb});
                return this.crypto.getPrivateKey(keyName, pwCb.getPassword());
            }
        }
        catch (Exception e) {
            LOG.debug("Cannot resolve PrivateKey", (Throwable)e);
        }
        return null;
    }
}

