/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.adapter.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.adapter.file.FileUtils;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.adapter.util.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.EncodingMap;
import de.pontonconsulting.xmlpipe.message.IBackEndMessage;
import de.pontonconsulting.xmlpipe.message.IPapinetMessage;
import de.pontonconsulting.xmlpipe.message.ITempCleanup;
import de.pontonconsulting.xmlpipe.message.NoBackendEnvelopeException;
import de.pontonconsulting.xmlpipe.message.SAXEnvelopeParser;
import de.pontonconsulting.xmlpipe.message.SAXWriter;
import de.pontonconsulting.xmlpipe.message.StopParsingException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BackEndMessage
implements IPapinetMessage,
IBackEndMessage,
ITempCleanup {
    private static final String EXT_XML = ".xml";
    private static final String PAYLOAD = "payload";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String TEXT_XML = "text/xml";
    private static final String TRUE = "true";
    protected static final String LINE_ENDING_LF = "LF";
    protected static final String LINE_ENDING_CR_LF = "CR LF";
    protected static final String LINE_ENDING_CR = "CR";
    private static final String PD_TYPE = "proct";
    private static final String PD_VALUE = "procv";
    private static final String ENVELOPE_PAYLOAD_MESSAGE = "/Envelope/Payload/Message";
    private static final String XPATH_SENDER_ORGANISATION = "/Envelope/TransmissionInformation/TransmissionOrganisationIdentifiers/SenderOrganisation";
    private static final String XPATH_RECEIVER_ORGANISATION = "/Envelope/TransmissionInformation/TransmissionOrganisationIdentifiers/ReceiverOrganisation";
    private static final String XPATH_MESSAGE_NAME = "/Envelope/Payload/MessageMetaData/DocumentInfo/@MessageName";
    private static final String XPATH_TEST_FLAG = "/Envelope/Payload/MessageMetaData/DocumentInfo/@TestFlag";
    private static final String XPATH_LOG_INFO = "/Envelope/Payload/MessageMetaData/DocumentInfo/LogInfo";
    private static final String XPATH_CONVERSATION_ID = "/Envelope/TransmissionInformation/TransmissionCharacteristics/ConversationID";
    private static final String XPATH_SEQUENCE_NUMBER = "/Envelope/TransmissionInformation/TransmissionCharacteristics/ConversationID/@SequenceNumber";
    private static final String XPATH_SEQUENCE_RESET = "/Envelope/TransmissionInformation/TransmissionCharacteristics/ConversationID/@SequenceReset";
    private static final String XPATH_MESSAGE_ID = "/Envelope/TransmissionInformation/TransmissionCharacteristics/TransferID";
    private static final String XPATH_DTD_VERSION = "/Envelope/Payload/MessageMetaData/DocumentInfo/DTDVersionNumber";
    private static final String XPATH_DTD_SET = "/Envelope/Payload/MessageMetaData/DocumentInfo/DTDSet";
    private static final String XPATH_PD_VALUE = "/Envelope/TransmissionInformation/ProcessingDirectives/Value";
    private static final String XPATH_PD_TYPE = "/Envelope/TransmissionInformation/ProcessingDirectives/Value/@Type";
    protected static final String UTF_8 = "UTF-8";
    private static final String MAX_SIZE_OVERRIDE = "ponton.xmlpipe.MaximumPayloadSize";
    private static final String MAX_SIZE = "1000000";
    public static final String TEST_FLAG_TRUE = "Test";
    public static final String TEST_FLAG_FALSE = "Production";
    public static final String OVERWRITE_MESSAGE_ID = "OverwriteMessageId";
    public static final String TRANSMISSION_MODE_BEST_EFFORT = "BestEffort";
    public static final String TRANSMISSION_MODE_EXACTLY_ONCE = "ExactlyOnce";
    private static final String MESSAGE_NAME = "MessageName";
    private static final String TEST_FLAG = "TestFlag";
    private static final String LOG_INFO = "LogInfo";
    private static final String DTD_VERSION_NUMBER = "DTDVersionNumber";
    private static final String DTD_SET = "DTDSet";
    private static final String TRANSFER_ID = "TransferID";
    private static final String CONVERSATION_ID = "ConversationID";
    private static final String SEQUENCE_NUMBER = "SequenceNumber";
    private static final String SEQUENCE_RESET = "SequenceReset";
    private static final String SENDER_ORG = "SenderOrganisation";
    private static final String RECEIVER_ORG = "ReceiverOrganisation";
    private static int _overideMaxSize;
    private String _transferIdText;
    private String _databaseId;
    private String _testFlagText;
    private String _senderOrganisationText;
    private String _receiverOrganisationText;
    private String _conversationIdText;
    private String _sequenceNumberText;
    private String _sequenceResetText;
    private String _dtdSetText;
    private String _dtdVersionNumberText;
    private String _messageName;
    private String _transmissionMode;
    private String _converterProductNameText;
    private String _converterVendorNameText;
    private String _converterVersionText;
    private String _erpProductNameText;
    private String _erpVendorNameText;
    private String _erpVersionText;
    private String _logInfoText;
    private String _keyLengthText;
    private String _transmissionTimeStampText;
    private String _transmissionProtocol;
    private boolean _papinetV1RxMessage;
    private String _senderUriText;
    private String _receiverUriText;
    private String _referenceId;
    private long _creationTimestamp;
    private File _sourceFile;
    private File _tempPayloadFile;
    private String _mimeType;
    private int _rawSize;
    private byte[] _rawPayload;
    private final HashMap<String, String> _processingDirectives = new HashMap();
    private boolean _backendEnvelope;
    private final HashMap<String, File> _attachments = new HashMap();
    private boolean _isAcknowledgement;
    private boolean _isXml;
    private String _charEncoding = "UTF-8";
    private String _lineEnding = "LF";
    private long _idTimestamp;

    public BackEndMessage(File storeMsg) throws BackEndMessageException {
        this();
        this.checkGivenFile(storeMsg);
        this.processPayload(storeMsg, this.isContentXML());
    }

    protected BackEndMessage() {
        this._creationTimestamp = System.currentTimeMillis();
    }

    public BackEndMessage(File storeMsg, boolean isXml) throws BackEndMessageException {
        this();
        this.checkGivenFile(storeMsg);
        this.processPayload(storeMsg, isXml);
    }

    private void checkGivenFile(File storeMsg) throws BackEndMessageException {
        if (storeMsg == null || !storeMsg.exists() || storeMsg.length() <= 0L) {
            throw new BackEndMessageException("File not found:" + storeMsg);
        }
        this._sourceFile = storeMsg;
        this._rawSize = (int)storeMsg.length();
    }

    private void processPayload(File storeMsg, boolean isXml) throws BackEndMessageException {
        if (isXml) {
            this._isXml = true;
            this._mimeType = TEXT_XML;
            try {
                this.parseEnvelope();
                this.extractPayloadData();
                this.detectAttachments();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BackEndMessageException(e);
            }
        }
        this._isXml = false;
        this._mimeType = MimeTypeMapper.getMimeType(this._sourceFile.getName());
        this.detectAttachments();
        try {
            this.writePayload();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.cleanupTempResources();
            throw new BackEndMessageException(e);
        }
    }

    private boolean isContentXML() {
        boolean bl;
        UTF8BOMSkippingInputStream inputStream = new UTF8BOMSkippingInputStream(new BufferedInputStream(this.getSourceStream()));
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            factory.setXMLReporter(null);
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(inputStream);
            xmlStreamReader.next();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        ((InputStream)inputStream).close();
        return bl;
    }

    private void writePayload() throws ParserConfigurationException, SAXException, IOException {
        block17: {
            try (InputStream source = this.getSourceStream();){
                if (this._rawSize < _overideMaxSize) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    this.writePayload(bout, source);
                    this._rawPayload = bout.toByteArray();
                    break block17;
                }
                this._rawPayload = null;
                this._tempPayloadFile = File.createTempFile(PAYLOAD, EXT_XML);
                try (FileOutputStream fOut = new FileOutputStream(this._tempPayloadFile);
                     BufferedOutputStream out = new BufferedOutputStream(fOut);){
                    this.writePayload(out, source);
                }
            }
        }
    }

    private void writePayload(OutputStream out, InputStream source) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = source.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    @Deprecated
    public BackEndMessage(byte[] messageData) throws BackEndMessageException {
        this(messageData, true);
    }

    @Deprecated
    public BackEndMessage(byte[] messageData, boolean isXml) throws BackEndMessageException {
        this();
        this._rawPayload = messageData;
        this._rawSize = messageData.length;
        if (isXml || this.isContentXML()) {
            this._isXml = isXml;
            this._mimeType = TEXT_XML;
            try {
                this.parseEnvelope();
                this.extractPayloadData();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BackEndMessageException(e);
            }
        }
    }

    private void detectAttachments() {
        String subdir;
        File subdirFile;
        File parentFolder = this._sourceFile.getParentFile();
        int index = this._sourceFile.getName().lastIndexOf(46);
        if (index > 0 && (subdirFile = new File(parentFolder, subdir = this._sourceFile.getName().substring(0, index))).exists() && subdirFile.isDirectory()) {
            this.findAttachmentsInFolder(subdirFile);
        }
    }

    private void findAttachmentsInFolder(File subdirFile) {
        File[] attachments = subdirFile.listFiles();
        for (int i = 0; i < attachments.length; ++i) {
            if (!attachments[i].canRead() || attachments[i].isDirectory()) continue;
            try {
                this.addAttachment(attachments[i]);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    protected boolean isInMemory() {
        return this._rawPayload != null;
    }

    public void setIANACharacterEncoding(String encoding) {
        this._charEncoding = EncodingMap.iana2java(encoding);
    }

    @Override
    public String getMimeType() {
        if (this._mimeType == null || this._mimeType.length() == 0) {
            if (this._isXml) {
                return TEXT_XML;
            }
            return APPLICATION_OCTET_STREAM;
        }
        return this._mimeType;
    }

    @Override
    public String getFilename() {
        String filename;
        if (this._databaseId != null) {
            filename = "payload-id-" + this._databaseId + MimeTypeMapper.getExtension(this.getMimeType());
        } else if (this._sourceFile == null) {
            if (this._idTimestamp == 0L) {
                this._idTimestamp = System.currentTimeMillis();
            }
            filename = "payload-time-" + this._idTimestamp + MimeTypeMapper.getExtension(this.getMimeType());
        } else {
            filename = this._sourceFile.getName();
        }
        return filename;
    }

    @Override
    public boolean isXml() {
        return this._isXml;
    }

    @Override
    public boolean isBackendEnvelope() {
        return this._backendEnvelope;
    }

    @Override
    public boolean isPapinetV1Rx0Message() {
        return this._papinetV1RxMessage;
    }

    @Override
    public boolean isAcknowledgement() {
        return this._isAcknowledgement;
    }

    @Override
    public void setIsAcknowledgement(boolean isAcknowledgement) {
        this._isAcknowledgement = isAcknowledgement;
    }

    @Override
    public int getNumberOfAttachments() {
        return this._attachments.size();
    }

    @Override
    public String[] listAttachments() {
        int i = 0;
        Set<String> set = this._attachments.keySet();
        String[] result = new String[this._attachments.size()];
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            result[i++] = iter.next();
        }
        return result;
    }

    @Override
    public File getAttachment(String filename) {
        return this._attachments.get(filename);
    }

    @Override
    public Iterator<File> getAttachments() {
        return this._attachments.values().iterator();
    }

    @Override
    public void addAttachment(File attachment) throws FileNotFoundException {
        this.addAttachment(attachment, MimeTypeMapper.getMimeType(attachment.getName()), null, null);
    }

    @Override
    public void addAttachment(File attachment, String type, String description, String language) throws FileNotFoundException {
        if (attachment == null || !attachment.exists()) {
            throw new FileNotFoundException("Cannot access the attachment");
        }
        this._attachments.put(attachment.getName(), attachment);
    }

    @Override
    public void addProcessingDirective(String pdType, String pdValue) {
        String extension;
        int extensionStartIndex;
        if (StringUtils.isBlank(pdValue)) {
            return;
        }
        this._processingDirectives.put(pdType, pdValue);
        if ("OriginalFilename".equals(pdType) && !this._isXml && (extensionStartIndex = pdValue.lastIndexOf(46)) >= 0 && StringUtils.isNotBlank(extension = pdValue.substring(extensionStartIndex + 1, pdValue.length()))) {
            this._mimeType = MimeTypeMapper.getMimeType(pdValue);
        }
    }

    @Override
    public void addProcessingDirective(String pdType, String[] pdValues) {
        if (pdValues == null) {
            this._processingDirectives.put(pdType, null);
        }
        this._processingDirectives.put(pdType, StringUtils.join(pdValues, ";"));
    }

    @Override
    public HashMap<String, String> getProcessingDirectivesMap() {
        return this._processingDirectives;
    }

    @Override
    public String[] getProcessingDirectiveAsStringArray(String key) {
        String value = this._processingDirectives.get(key);
        if (value == null) {
            return null;
        }
        return StringUtils.listToStringArray(value);
    }

    @Override
    public String getProcessingDirectiveAsString(String key) {
        String value = this._processingDirectives.get(key);
        return value;
    }

    @Override
    public Boolean getProcessingDirectiveAsBoolean(String key) {
        String value = this._processingDirectives.get(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public Integer getProcessingDirectiveAsInteger(String key) {
        String value = this._processingDirectives.get(key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Long getProcessingDirectiveAsLong(String key) {
        String value = this._processingDirectives.get(key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public String getTransferIDText() {
        return this._transferIdText;
    }

    @Override
    public void setTransferID(String transferId) {
        this._transferIdText = transferId != null ? transferId.trim() : null;
    }

    @Override
    public String getConversationIDText() {
        return this._conversationIdText;
    }

    @Override
    public void setConversationID(String conversationId) {
        this._conversationIdText = conversationId != null ? conversationId.trim() : null;
    }

    @Override
    public String getSequenceNumberText() {
        return this._sequenceNumberText;
    }

    @Override
    public void setSequenceNumber(long sequence) {
        this._sequenceNumberText = String.valueOf(sequence);
        if (sequence == 0L) {
            this._sequenceResetText = TRUE;
        }
    }

    @Override
    public String getTestFlag() {
        return this._testFlagText;
    }

    @Override
    public void setTestFlag(String testFlag) {
        this._testFlagText = testFlag != null ? testFlag.trim() : null;
    }

    @Override
    public String getSenderOrganisationText() {
        return this._senderOrganisationText;
    }

    @Override
    public void setSenderOrganisation(String senderId) {
        this._senderOrganisationText = senderId != null ? senderId.trim() : null;
    }

    @Override
    public String getReceiverOrganisationText() {
        return this._receiverOrganisationText;
    }

    @Override
    public void setReceiverOrganisation(String receiverId) {
        this._receiverOrganisationText = receiverId != null ? receiverId.trim() : null;
    }

    @Override
    public String getTransmissionTimeStampText() {
        return this._transmissionTimeStampText;
    }

    @Override
    public void setTransmissionTimeStamp(String transmissionTimeStamp) {
        this._transmissionTimeStampText = transmissionTimeStamp != null ? transmissionTimeStamp.trim() : null;
    }

    @Override
    public String getSenderURIText() {
        return this._senderUriText;
    }

    @Override
    public String getReceiverURIText() {
        return this._receiverUriText;
    }

    @Override
    public String getDTDSetText() {
        return this._dtdSetText;
    }

    @Override
    public void setDTDSet(String dtdSet) {
        this._dtdSetText = dtdSet != null ? dtdSet.trim() : null;
    }

    @Override
    public String getDTDVersionNumberText() {
        return this._dtdVersionNumberText;
    }

    @Override
    public void setDTDVersionNumber(String dtdVersion) {
        this._dtdVersionNumberText = dtdVersion != null ? dtdVersion.trim() : null;
    }

    @Override
    public String getMessageName() {
        return this._messageName;
    }

    @Override
    public void setMessageName(String messageName) {
        this._messageName = messageName != null ? messageName.trim() : null;
    }

    @Override
    public String getTransmissionMode() {
        return this._transmissionMode;
    }

    @Override
    public String getTransmissionProtocol() {
        return this._transmissionProtocol;
    }

    @Override
    public void setTransmissionProtocol(String protocol) {
        this._transmissionProtocol = protocol != null ? protocol.trim() : null;
    }

    @Override
    public void setTransmissionMode(String transmissionMode) {
        this._transmissionMode = transmissionMode != null ? transmissionMode.trim() : null;
    }

    @Override
    public String getConverterProductNameText() {
        return this._converterProductNameText;
    }

    @Override
    public String getConverterVendorNameText() {
        return this._converterVendorNameText;
    }

    @Override
    public String getConverterVersionText() {
        return this._converterVersionText;
    }

    @Override
    public String getERPProductNameText() {
        return this._erpProductNameText;
    }

    @Override
    public String getERPVendorNameText() {
        return this._erpVendorNameText;
    }

    @Override
    public String getERPVersionText() {
        return this._erpVersionText;
    }

    @Override
    public String getLogInfoText() {
        return this._logInfoText;
    }

    @Override
    public void setLogInfoText(String logInfo) {
        this._logInfoText = logInfo != null ? logInfo.trim() : null;
    }

    @Override
    @Deprecated
    public void setLogInfoTest(String logInfo) {
        this._logInfoText = logInfo != null ? logInfo.trim() : null;
    }

    @Override
    public String getKeyLengthText() {
        return this._keyLengthText;
    }

    @Override
    public void writeMessageDocumentTo(File payloadFile) throws BackEndMessageException {
        if (this._tempPayloadFile != null && !this._papinetV1RxMessage) {
            try {
                FileUtils.copy(this._tempPayloadFile, payloadFile);
            }
            catch (IOException ioe) {
                throw new BackEndMessageException("Could not write message document.", ioe);
            }
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(payloadFile.toPath(), new OpenOption[0]));){
            this.writeMessageDocumentTo(out);
        }
        catch (IOException e) {
            throw new BackEndMessageException("File could not be written:" + e.getMessage(), e);
        }
    }

    public InputStream getMessageDocumentInputStream() throws BackEndMessageException {
        InputStream in;
        if (this._rawPayload != null) {
            in = new ByteArrayInputStream(this._rawPayload);
        } else if (this._tempPayloadFile != null) {
            try {
                in = new BufferedInputStream(Files.newInputStream(this._tempPayloadFile.toPath(), new OpenOption[0]));
            }
            catch (IOException e) {
                throw new BackEndMessageException(e);
            }
        } else {
            throw new BackEndMessageException("payload data is missing.");
        }
        return in;
    }

    @Override
    public void writeMessageDocumentTo(OutputStream out) throws BackEndMessageException {
        block12: {
            if (this._rawPayload != null) {
                try {
                    out.write(this._rawPayload);
                }
                catch (IOException e) {
                    throw new BackEndMessageException(e);
                }
            }
            if (this._tempPayloadFile != null) {
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this._tempPayloadFile));){
                    int temp = -1;
                    while ((temp = bis.read()) != -1) {
                        out.write(temp);
                    }
                    out.flush();
                    bis.close();
                    break block12;
                }
                catch (IOException e) {
                    throw new BackEndMessageException(e);
                }
            }
            throw new BackEndMessageException("payload data is missing.");
        }
    }

    @Override
    public void writeBackEndEnvelopeTo(File backendEnvelopeFile) throws BackEndMessageException {
        try (FileOutputStream fos = new FileOutputStream(backendEnvelopeFile);){
            this.constructBackEndMessage(fos, false);
        }
        catch (IOException e) {
            throw new BackEndMessageException(e);
        }
    }

    private void constructBackEndMessage(OutputStream out, boolean includePayload) throws BackEndMessageException {
        try (InputStream in = this.getPayloadStream();){
            if (!this._papinetV1RxMessage) {
                this.writeBackendMessageWithEnvelope(out, includePayload, in);
            } else {
                this.writePapinet1Payload(out, in);
            }
        }
        catch (Exception e) {
            throw new BackEndMessageException(e);
        }
    }

    private void writePapinet1Payload(OutputStream out, InputStream in) throws IOException {
        if (this._rawPayload != null) {
            out.write(this._rawPayload);
            out.flush();
        } else {
            int length = -1;
            byte[] buffer = new byte[32768];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            out.flush();
        }
    }

    private void writeBackendMessageWithEnvelope(OutputStream out, boolean includePayload, InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXWriter writer = new SAXWriter();
        writer.setOutput(out, this._charEncoding);
        writer.setLineEnding(this._lineEnding);
        writer.setBackendMessage(this);
        if (this._isXml && includePayload) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            try {
                saxParser.parse(in, (DefaultHandler)writer);
            }
            catch (StopParsingException stopParsingException) {}
        } else {
            writer.envelopeOnly();
        }
    }

    @Override
    public void writeBackEndEnvelopeTo(OutputStream out) throws BackEndMessageException {
        this.constructBackEndMessage(out, false);
    }

    @Override
    public void writeBackEndMessageTo(File backendMessageFile) throws BackEndMessageException {
        try (FileOutputStream fos = new FileOutputStream(backendMessageFile);){
            this.constructBackEndMessage(fos, true);
        }
        catch (IOException e) {
            throw new BackEndMessageException(e);
        }
    }

    @Override
    public void writeBackEndMessageTo(OutputStream out) throws BackEndMessageException {
        this.constructBackEndMessage(out, true);
    }

    @Deprecated
    public byte[] getMessageDocumentBytes() {
        return this.getDocumentBytes();
    }

    @Deprecated
    public byte[] getDocumentBytes() {
        this.loadDocumentToMemory(this._tempPayloadFile);
        return this._rawPayload;
    }

    @Deprecated
    public byte[] getBackEndMessageBytes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.constructBackEndMessage(bout, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bout.toByteArray();
    }

    private void loadDocumentToMemory(File file) {
        if (this._rawPayload == null) {
            this._rawPayload = new byte[(int)file.length()];
            try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                ((InputStream)fis).read(this._rawPayload);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseEnvelope() throws BackEndMessageException, ParserConfigurationException, SAXException {
        try (InputStream source = this.getSourceStream();){
            SAXEnvelopeParser handler = new SAXEnvelopeParser();
            handler.addCustomXPath(SENDER_ORG, XPATH_SENDER_ORGANISATION, false);
            handler.addCustomXPath(RECEIVER_ORG, XPATH_RECEIVER_ORGANISATION, false);
            handler.addCustomXPath(MESSAGE_NAME, XPATH_MESSAGE_NAME, false);
            handler.addCustomXPath(DTD_VERSION_NUMBER, XPATH_DTD_VERSION, false);
            handler.addCustomXPath(DTD_SET, XPATH_DTD_SET, false);
            handler.addCustomXPath(TEST_FLAG, XPATH_TEST_FLAG, false);
            handler.addCustomXPath(TRANSFER_ID, XPATH_MESSAGE_ID, false);
            handler.addCustomXPath(CONVERSATION_ID, XPATH_CONVERSATION_ID, false);
            handler.addCustomXPath(SEQUENCE_NUMBER, XPATH_SEQUENCE_NUMBER, false);
            handler.addCustomXPath(SEQUENCE_RESET, XPATH_SEQUENCE_RESET, false);
            handler.addCustomXPath(LOG_INFO, XPATH_LOG_INFO, false);
            handler.addCustomXPath(PD_VALUE, XPATH_PD_VALUE, true);
            handler.addCustomXPath(PD_TYPE, XPATH_PD_TYPE, true);
            handler.stopOnElement(ENVELOPE_PAYLOAD_MESSAGE);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            this.parseEnvelopeUntilPayloadStarts(source, handler, saxParser);
            this.setMessageName(handler.getValue(MESSAGE_NAME));
            this.setDTDVersionNumber(handler.getValue(DTD_VERSION_NUMBER));
            this.setDTDSet(handler.getValue(DTD_SET));
            this.setTestFlag(handler.getValue(TEST_FLAG));
            this.setSenderOrganisation(handler.getValue(SENDER_ORG));
            this.setReceiverOrganisation(handler.getValue(RECEIVER_ORG));
            this.setTransferID(handler.getValue(TRANSFER_ID));
            this.setConversationID(handler.getValue(CONVERSATION_ID));
            String sequenceNumber = handler.getValue(SEQUENCE_NUMBER);
            if (sequenceNumber != null) {
                String resetText = handler.getValue(SEQUENCE_RESET);
                boolean reset = TRUE.equalsIgnoreCase(resetText);
                this.setSequenceReset(reset);
                this.setSequenceNumber(Long.parseLong(sequenceNumber));
            }
            this.setLogInfoText(handler.getValue(LOG_INFO));
            this.setProcessingDirectives(handler.getValues(PD_TYPE), handler.getValues(PD_VALUE));
            this._papinetV1RxMessage = handler.isBackendEnvelope() && this.getConversationIDText() == null;
            this._backendEnvelope = handler.isBackendEnvelope() && this.getConversationIDText() != null;
        }
        catch (IOException ioe) {
            throw new BackEndMessageException(ioe);
        }
    }

    private void parseEnvelopeUntilPayloadStarts(InputStream source, SAXEnvelopeParser handler, SAXParser saxParser) throws SAXException, IOException {
        try {
            saxParser.parse(source, (DefaultHandler)handler);
        }
        catch (NoBackendEnvelopeException | StopParsingException sAXException) {
            // empty catch block
        }
    }

    private InputStream getPayloadStream() throws FileNotFoundException {
        if (this._rawPayload != null) {
            return new ByteArrayInputStream(this._rawPayload);
        }
        return new FileInputStream(this._tempPayloadFile);
    }

    private InputStream getSourceStream() throws IOException {
        InputStream source = null;
        if (this._rawPayload != null) {
            source = new ByteArrayInputStream(this._rawPayload);
        } else if (this._sourceFile != null) {
            source = new BufferedInputStream(Files.newInputStream(this._sourceFile.toPath(), new OpenOption[0]));
        }
        return source;
    }

    public File getSourceFile() {
        return this._sourceFile;
    }

    private void setProcessingDirectives(String[] types, String[] values) {
        for (int i = 0; i < types.length; ++i) {
            this.addProcessingDirective(types[i], values[i]);
        }
    }

    private void extractPayloadData() throws ParserConfigurationException, SAXException, IOException {
        block12: {
            try (InputStream source = this.getSourceStream();){
                if (this._rawSize < _overideMaxSize) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    this.extractPayload(bout, source);
                    this._rawPayload = bout.toByteArray();
                    break block12;
                }
                this._rawPayload = null;
                this._tempPayloadFile = File.createTempFile(PAYLOAD, EXT_XML);
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this._tempPayloadFile));){
                    this.extractPayload(out, source);
                }
            }
        }
    }

    private void extractPayload(OutputStream out, InputStream source) throws ParserConfigurationException, SAXException, IOException {
        if (this._backendEnvelope) {
            SAXWriter writer = new SAXWriter();
            writer.setOutput(out, this._charEncoding);
            writer.setLineEnding(this._lineEnding);
            writer.startOnElement(ENVELOPE_PAYLOAD_MESSAGE);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", writer);
            try {
                saxParser.parse(source, (DefaultHandler)writer);
            }
            catch (StopParsingException stopParsingException) {}
        } else {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = source.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    @Override
    public void addProcessableAttachment(File attachment) throws FileNotFoundException {
        throw new FileNotFoundException("the method is not implemented yet");
    }

    @Override
    public void addProcessableAttachment(File attachment, String type, String description, String language) throws FileNotFoundException {
        throw new FileNotFoundException("the method is not implemented yet");
    }

    public void setCharEncoding(String charEncoding) {
        this._charEncoding = charEncoding;
    }

    public String getCharEncoding() {
        return this._charEncoding;
    }

    @Override
    public String getReferenceId() {
        return this._referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this._referenceId = referenceId;
    }

    public String getLineEnding() {
        return this._lineEnding;
    }

    public void setLineEnding(String lineEnding) {
        this._lineEnding = lineEnding;
    }

    @Override
    public String getDatabaseId() {
        return this._databaseId;
    }

    public void setDatabaseId(String databaseId) {
        this._databaseId = databaseId;
    }

    public long getCreationTimestamp() {
        return this._creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this._creationTimestamp = creationTimestamp;
    }

    public String getSequenceResetText() {
        return this._sequenceResetText;
    }

    public void setSequenceReset(boolean sequenceReset) {
        if (sequenceReset) {
            this._sequenceResetText = TRUE;
        }
    }

    static void setMaxMemoryPayloadSize(int size) {
        _overideMaxSize = size;
    }

    @Override
    public void cleanupTempResources() {
        if (this._tempPayloadFile != null) {
            this._tempPayloadFile.delete();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanupTempResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    static {
        String maxSize = System.getProperty(MAX_SIZE_OVERRIDE, MAX_SIZE);
        _overideMaxSize = Integer.parseInt(maxSize);
    }
}

