/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.HttpServer;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunication;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunicationFactory;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.MessengerCommunicationFactory;
import de.pontonconsulting.xmlpipe.adapter.StatusResult;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericAdapter {
    public static final String BACKEND_MESSAGE_FILE = "xp_backendmessage.xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT = "text";
    public static final String MULTIPART = "multipart";
    public static final String COMMAND_PARTNER_ADDED = "PartnerAdded";
    public static final String COMMAND_PARTNER_MODIFIED = "PartnerModified";
    public static final String COMMAND_PARTNER_DELETED = "PartnerDeleted";
    public static final String COMMAND_AGREEMENT_ADDED = "AgreementAdded";
    public static final String COMMAND_AGREEMENT_MODIFED = "AgreementModified";
    public static final String COMMAND_AGREEMENT_DELETED = "AgreementDeleted";
    public static final String COMMAND_GET_HTML = "GetHtml";
    public static final String COMMAND_GET_XML = "GetXml";
    public static final String COMMAND_CHECK_CONNECTION = "CheckConnection";
    public static final String COMMAND_SEND_DOCUMENT = "SendDocument";
    public static final String COMMAND_ARCHIVE_DOCUMENT = "ArchiveDocument";
    public static final String COMMAND_UNREGISTER = "Unregister";
    public static final String COMMAND_REGISTER = "Register";
    public static final String COMMAND_PARTNER_EXISTS = "PartnerExists";
    public static final String COMMAND_GET_FULL_PARTNER_LIST = "GetFullPartnerList";
    public static final String COMMAND_GET_LOCAL_PARTNER_LIST = "GetLocalPartnerList";
    public static final String COMMAND_GET_REMOTE_PARTNER_LIST = "GetRemotePartnerList";
    public static final String COMMAND_GET_AGREEMENT_PARTNERS_LIST = "GetAgreementPartnersList";
    public static final String COMMAND_GET_SCHEMA_SETS = "GetSchemaSets";
    public static final String COMMAND_RECEIVE_DOCUMENT = "ReceiveDocument";
    public static final String COMMAND_STATUS = "Status";
    public static final String COMMAND_DO_SELF_CHECK = "DoSelfCheck";
    public static final String COMMAND_SHUTDOWN = "Shutdown";
    public static final String COMMAND_PING = "Ping";
    public static final String COMMAND_SERVICE_REGISTER = "RegisterService";
    public static final String COMMAND_SERVICE_UNREGISTER = "UnregisterService";
    public static final String COMMAND_SERVICE_LIST = "QueryServiceList";
    public static final String COMMAND_RECEIVE_PACKET = "ReceivePacket";
    public static final String COMMAND_SEND_PACKET = "SendPacket";
    public static final String COMMAND = "X-COMMAND";
    public static final String COMMAND_STATUS_REQUEST = "StatusRequest";
    public static final String COMMAND_LOCAL_STATUS_REQUEST = "LocalStatusRequest";
    public static final String COMMAND_PARTNER_CERTIFICATE_ADDED = "PartnerCertificateAdded";
    public static final String COMMAND_PARTNER_CERTIFICATE_DELETED = "PartnerCertificateDeleted";
    public static final String COMMAND_CERT_UPDATE = "CertUpdateID";
    public static final String IDENTIFIER = "X-AdapterId";
    public static final String ADAPTER_API_VERSION = "X-AdapterAPI-Version";
    public static final String SUPPORTS_ACK = "SupportsAcknowledgements";
    public static final String SUPPORTS_RESPONSES = "SupportsResponses";
    public static final String SUPPORTS_ERROR_NOTIFICATIONS = "SupportsErrorNotifications";
    public static final String SUPPORTS_ATTACHMENTS = "SupportsAttachments";
    public static final String ACCEPTS_PARTNER_CHANGE_EVENTS = "AcceptsPartnerChangeEvents";
    public static final String ACCEPTS_PARTNER_CERTIFICATE_CHANGE_EVENTS = "AcceptsPartnerCertificateChangeEvents";
    public static final String ACCEPTS_AGREEMENT_CHANGE_EVENTS = "AcceptsPartnerAgreementEvents";
    public static final String MAXIMUM_THREADS = "MaximumThreads";
    public static final String URL = "URL";
    public static final String OLD_PARTNERID = "X-Ponton-OldPartnerID";
    public static final String PARTNER_DISPLAYNAME = "X-Ponton-PartnerDisplayName";
    public static final String IS_LOCAL_PARTNER = "X-Ponton-IsLocalPartner";
    public static final String NUMBER_SERVICES = "X-NumberOfServices";
    public static final String SERVICE_ID = "X-ServiceId";
    public static final String SERVICE_ENCRYPTION = "X-ServiceEncryption";
    public static final String REFERENCE_ID = "X-ReferenceId";
    public static final String PARTNERID_SENDER = "X-SenderId";
    public static final String PARTNERID_RECEIVER = "X-ReceiverId";
    public static final Object CERT_UPDATE_ID = "X-CertID";
    public static final String TEST_FLAG = "X-TestFlag";
    public static final String ACK_REQUESTED = "X-AckRequested";
    public static final String PROCESSING_DIRECTIVE = "X-ProcessingDirective";
    public static final String DEFAULT_MESSENGER_PATH = "/pontonxp/AdapterService";
    public static final String IS_ACK = "X-Acknowledgement";
    public static final String PROCESSING_TIMEOUT = "X-ProcessingTimeout";
    public static final int PROCESSING_TIMEOUT_DEFAULT_SECONDS = 600;
    public static final String PROPERTY_ADAPTERIP = "pontonxp.adapterIP";
    public static final String XP_MESSAGE_RESULT_CODE = "XPMessageResultCode";
    public static final String MAINTENANCE_MODE = "X-MaintenanceMode";
    public static final String NUMBER_SCHEMA_SETS = "NumberOfSchemaSets";
    public static final String SCHEMA_SET = "X-SchemaSet";
    public static final String LOCAL_PARTNER_ID = "LocalPartnerID";
    public static final String REMOTE_PARTNER_ID = "RemotePartnerID";
    public static final String NUMBER_OF_AGREEMENTS = "NumberOfAgreements";
    public static final String AGREEMENT_LOCAL_PARTNER_ID = "X-Ponton-Agreement-LocalPartnerId";
    public static final String AGREEMENT_REMOTE_PARTNER_ID = "X-Ponton-Agreement-RemotePartnerId";
    public static final String NUMBER_OF_PARTNERS = "NumberOfPartners";
    public static final String PARTNERID = "PartnerID";
    public static final String PARTNER_CERTIFICATE = "PartnerCertificate";
    public static final String MESSAGE_ID = "X-MessageId";
    public static final String CONVERSATION_ID = "X-ConversationId";
    public static final String MESSAGE_TYPE = "X-MessageType";
    public static final String SCHEMA_VERSION = "X-SchemaVersion";
    public static final String MESSAGE_TIME = "X-MessageTime";
    public static final String TRANSMISSION_PROTOCOL = "X-TransmissionProtocol";
    public static final String RESULT_PROPERTY_HEADER = "X-ExtendedResultData";
    public static final String RESULT_PROPERTY_XP_CODE = "result.xpCode";
    public static final String RESULT_PROPERTY_DESCRIPTION = "result.description";
    public static final String RESULT_PROPERTY_MESSAGE_ID = "result.messageId";
    public static final String RESULT_PROPERTY_CONVERSATION_ID = "result.conversationId";
    public static final String RESULT_PROPERTY_MESSAGE_TYPE = "result.messageType";
    public static final String RESULT_PROPERTY_SCHEMA_VERSION = "result.schemaVersion";
    public static final String RESULT_PROPERTY_SCHEMA_SET = "result.schemaSet";
    public static final String RESULT_PROPERTY_MESSAGE_TIME = "result.messageTime";
    public static final String RESULT_PROPERTY_TRANSMISSION_PROTOCOL = "result.transmissionProtocol";
    public static final String RESULT_PROPERTY_MAINTENANCE_MODE = "result.maintenanceMode";
    public static final String RESULT_PROPERTY_SENDER_ID = "result.senderId";
    public static final String RESULT_PROPERTY_RECEIVER_ID = "result.receiverId";
    public static final String RESULT_PROPERTY_TEST_MESSAGE = "result.testMessage";
    public static final String RESULT_PROPERTY_PROCESSING_DIRECTIVE_PREFIX = "result.processingDirective";
    public static final String RESULT_PROPERTY_PROCESSING_DIRECTIVE_KEY_SUFFIX = ".key";
    public static final String RESULT_PROPERTY_PROCESSING_DIRECTIVE_VALUE_SUFFIX = ".value";
    public static final String RESULT_PROPERTY_NUMBER_OF_SCHEMA_SETS = "result.numberOfSchemaSets";
    public static final String RESULT_PROPERTY_LOCAL_PARTNER_ID = "resul.localPartnerId";
    public static final String RESULT_PROPERTY_REMOTE_PARTNER_ID = "result.remotePartnerId";
    public static final String RESULT_PROPERTY_NUMBER_OF_AGREEMENTS = "result.numberOfAgreements";
    public static final String RESULT_PROPERTY_AGREEMENT_LOCAL_PARTNER_ID = "result.agreementLocalPartnerId";
    public static final String RESULT_PROPERTY_AGREEMENT_REMOTE_PARTNER_ID = "result.agreementRemotePartnerId";
    public static final String RESULT_PROPERTY_NUMBER_OF_PARTNERS = "result.numberOfPartners";
    public static final String RESULT_PROPERTY_PARTNERID = "result.partnerId";
    public static final String RESULT_PROPERTY_PARTNERCERTIFICATE = "result.partnercertificate";
    private static final Object RESULT_PROPERTY_PARTNERCERTIFICATE_ID = "result.partnercertificateId";
    protected static final Map RESULT_KEY_MAPPING = new HashMap();
    private final Log _log;
    private final LinkedList _messengers = new LinkedList();
    private final LinkedList _unavailableMessengers = new LinkedList();
    private ISpecificAdapter _endAdapter;
    private final String _logCategory;
    private final Object _lock = new Object();
    private boolean _doUnavailableMessengerCheck;
    private Thread _messengerCheck;
    private int _processingTimeout = 600;
    private int _serverPort = 0;
    private String _adapterIP = null;
    private HttpServer _server;

    public GenericAdapter(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, String logCategory) throws AdapterException, IOException {
        this(endAdapter, messengerHost, messengerPort, messengerPath, 0, logCategory);
    }

    public GenericAdapter(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, int serverPort, String logCategory) throws AdapterException, IOException {
        this(endAdapter, new String[]{messengerHost}, new int[]{messengerPort}, new String[]{messengerPath}, new int[]{serverPort}, logCategory);
    }

    public GenericAdapter(ISpecificAdapter endAdapter, String messengerHost, int messengerPort, String messengerPath, int serverPort, String logCategory, int processingTimeout) throws AdapterException, IOException {
        this(endAdapter, new String[]{messengerHost}, new int[]{messengerPort}, new String[]{messengerPath}, new int[]{serverPort}, logCategory, processingTimeout);
    }

    public GenericAdapter(ISpecificAdapter endAdapter, String[] messengerHosts, int[] messengerPorts, String[] messengerPaths, String logCategory) throws AdapterException, IOException {
        this(endAdapter, messengerHosts, messengerPorts, messengerPaths, null, logCategory);
    }

    public GenericAdapter(ISpecificAdapter endAdapter, String[] messengerHosts, int[] messengerPorts, String[] messengerPaths, int[] serverPorts, String logCategory) throws AdapterException, IOException {
        this(endAdapter, messengerHosts, messengerPorts, messengerPaths, serverPorts, logCategory, 600);
    }

    public GenericAdapter(ISpecificAdapter endAdapter, String[] messengerHosts, int[] messengerPorts, String[] messengerPaths, int[] serverPorts, String logCategory, int processingTimeout) throws AdapterException, IOException {
        this(logCategory);
        int i;
        this.setEndAdapter(endAdapter);
        if (processingTimeout == 0) {
            processingTimeout = 600;
        }
        this.setProcessingTimeout(processingTimeout);
        int serverPort = -1;
        int[] sPorts = null;
        if (serverPorts == null) {
            sPorts = new int[messengerHosts.length];
            for (i = 0; i < sPorts.length; ++i) {
                sPorts[i] = 0;
            }
            serverPort = 0;
        } else {
            sPorts = serverPorts;
            for (i = 0; i < serverPorts.length; ++i) {
                int port = serverPorts[i];
                if (port == 0 && serverPort < 0) {
                    serverPort = 0;
                    continue;
                }
                if (port <= 0) continue;
                serverPort = port;
                break;
            }
        }
        if (messengerHosts.length > 0 && messengerHosts.length == messengerPorts.length && messengerHosts.length == messengerPaths.length && messengerHosts.length == sPorts.length) {
            this.setServerPort(serverPort);
            int connectedMessengers = 0;
            for (int i2 = 0; i2 < messengerHosts.length; ++i2) {
                try {
                    this.addMessengerConnection(messengerHosts[i2], messengerPorts[i2], messengerPaths[i2]);
                    ++connectedMessengers;
                    continue;
                }
                catch (Exception e) {
                    this._log.error((Object)("could not register with messenger at " + messengerHosts[i2] + ":" + messengerPorts[i2] + " " + e.getMessage()));
                }
            }
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Initialized " + connectedMessengers + " messenger connections."));
            }
            if (connectedMessengers == 0) {
                this.shutdown();
                throw new AdapterException("could not register Adapter with any Messenger instance.");
            }
        } else {
            throw new AdapterException("Unable to create multiple messenger connection. Parameter count is not identical.");
        }
    }

    public ISpecificAdapter getEndAdapter() {
        return this._endAdapter;
    }

    public void setEndAdapter(ISpecificAdapter endAdapter) {
        this._endAdapter = endAdapter;
    }

    public int getProcessingTimeout() {
        return this._processingTimeout;
    }

    public void setProcessingTimeout(int processingTimeout) {
        this._processingTimeout = processingTimeout;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public String getAdapterIP() {
        return this._adapterIP;
    }

    public void setAdapterIP(String adapterIP) {
        this._adapterIP = adapterIP;
    }

    public GenericAdapter(String logCategory) {
        this._logCategory = logCategory;
        this._log = LogFactory.getFactory().getInstance(logCategory + ".GenericAdapter");
    }

    private synchronized void start() throws AdapterException, IOException {
        if (this._doUnavailableMessengerCheck) {
            throw new AdapterException("GenericAdapter is already initialized.");
        }
        if (this._endAdapter == null) {
            throw new AdapterException("EndAdapter is not set.");
        }
        if (this._serverPort >= 0) {
            try {
                ServiceLoader<HttpServer> loader = ServiceLoader.load(HttpServer.class);
                for (HttpServer httpServer : loader) {
                    httpServer.init(this._endAdapter, this._serverPort, this._endAdapter.getNumberOfParallelThreads(), this._logCategory);
                    this._server = httpServer;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this._log.error((Object)("http server could not be started: " + e));
                throw new IOException("Http server could not be started: " + e);
            }
        } else {
            this._log.info((Object)"Message reception is disabled. Http Server is not started");
        }
        this._doUnavailableMessengerCheck = true;
        this._messengerCheck = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (GenericAdapter.this._doUnavailableMessengerCheck) {
                    try {
                        Thread.sleep(300000L);
                        Object object = GenericAdapter.this._lock;
                        synchronized (object) {
                            if (GenericAdapter.this._unavailableMessengers.size() > 0) {
                                GenericAdapter.this.checkUnavailableMessengers();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        this._messengerCheck.setName("MessengerConnectionCheck[" + this._endAdapter.getID() + "]");
        this._messengerCheck.setDaemon(true);
        this._messengerCheck.start();
    }

    public void addMessengerConnection(String messengerHost, int messengerPort, String messengerPath, int serverPort) throws AdapterException, IOException {
        this.setServerPort(serverPort);
        this.addMessengerConnection(messengerHost, messengerPort, messengerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessengerConnection(String messengerHost, int messengerPort, String messengerPath) throws AdapterException, IOException {
        Object object = this._lock;
        synchronized (object) {
            IMessengerCommunicationFactory messengerCommunicationFactory = MessengerCommunicationFactory.getInstance();
            if (!this._doUnavailableMessengerCheck) {
                this.start();
            }
            int usedServerPort = this._server == null ? -1 : this._server.getServerPort();
            IMessengerCommunication messenger = messengerCommunicationFactory.getMessengerConnection(this._endAdapter, messengerHost, messengerPort, messengerPath, this._logCategory, this._processingTimeout, usedServerPort, this._adapterIP);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Registering Adapter at Messenger.");
            }
            try {
                MessageResult result = messenger.registerAdapter(this._endAdapter);
                if (!result.equals(MessageResult.ADAPTER_SUCCESSFULLY_REGISTERED)) {
                    throw new AdapterException("Adapter not registered:" + result.getDescription());
                }
            }
            catch (AdapterException e) {
                try {
                    messenger.unregisterAdapter(this._endAdapter.getID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            this._messengers.add(messenger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult archiveMessage(BackEndMessage message) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            MessageResult messageResult = messengerCommunication.archiveDocument(message, this._endAdapter.getID());
            return messageResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPartnerList() throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            String[] stringArray = messengerCommunication.getFullPartnerList();
            return stringArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocalPartnerList() throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            String[] stringArray = messengerCommunication.getLocalPartnerList();
            return stringArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRemotePartnerList() throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            String[] stringArray = messengerCommunication.getRemotePartnerList();
            return stringArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgreementPartners[] getAgreementPartnersList() throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            AgreementPartners[] agreementPartnersArray = messengerCommunication.getAgreementPartnersList();
            return agreementPartnersArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean partnerExists(String partnerId) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            boolean bl = messengerCommunication.partnerExists(partnerId);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSchemaSets(String localPartner, String remotePartner) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            String[] stringArray = messengerCommunication.getSchemaSets(localPartner, remotePartner);
            return stringArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult sendMessage(BackEndMessage message) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                MessageResult messageResult = messengerCommunication.sendOutboundDocument(message, this._endAdapter.getID());
                message.cleanupTempResources();
                return messageResult;
            }
            catch (Throwable throwable) {
                message.cleanupTempResources();
                throw throwable;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult sendPing(String senderId, String receiverId) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            MessageResult messageResult = messengerCommunication.pingPartner(senderId, receiverId, this._endAdapter.getID());
            return messageResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageResult> sendPings(String senderId, String receiverId) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            List<MessageResult> list = messengerCommunication.pingPartnerEndpoints(senderId, receiverId, this._endAdapter.getID());
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResult sendStatusRequest(String senderId, String receiverId, String referenceID) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            MessageResult messageResult = messengerCommunication.sendStatusRequest(senderId, receiverId, referenceID, this._endAdapter.getID());
            return messageResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusResult sendLocalStatusRequest(String messageId) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            StatusResult statusResult = messengerCommunication.sendLocalStatusRequest(messageId, this._endAdapter.getID());
            return statusResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXmlDocumentTo(String messageId, OutputStream out) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            messengerCommunication.writeXmlDocumentTo(messageId, out);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHtmlDocumentTo(String messageId, OutputStream out) throws AdapterException {
        IMessengerCommunication messengerCommunication = this.getMessengerConnection();
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = messengerCommunication.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            messengerCommunication.writeHtmlDocumentTo(messageId, out);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageResult shutdown() {
        MessageResult[] mrs;
        if (this._doUnavailableMessengerCheck) {
            this._doUnavailableMessengerCheck = false;
            this._messengerCheck.interrupt();
            if (this._server != null) {
                this._server.stopServer();
            }
        }
        Object object = this._lock;
        synchronized (object) {
            mrs = new MessageResult[this._messengers.size()];
            for (int i = 0; i < this._messengers.size(); ++i) {
                IMessengerCommunication messenger = (IMessengerCommunication)this._messengers.remove(i);
                String reconnectFlag = System.getProperty("ponton.xmlpipe.adapter.reconnecttest");
                if (reconnectFlag == null || !"true".equals(reconnectFlag)) {
                    try {
                        mrs[i] = messenger.unregisterAdapter(this._endAdapter.getID());
                    }
                    catch (AdapterException e) {
                        this._log.warn((Object)("could not unregister adapter '" + this._endAdapter.getID() + "' by " + messenger.getName()));
                    }
                    continue;
                }
                mrs[i] = new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_UNREGISTERED);
            }
            this._unavailableMessengers.clear();
            this._server = null;
        }
        if (mrs.length > 0) {
            return mrs[0];
        }
        return new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_UNREGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfMessengerConnections() {
        Object object = this._lock;
        synchronized (object) {
            return this._messengers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessengerCommunication getMessengerConnection() throws AdapterException {
        IMessengerCommunication messenger = null;
        boolean foundWorkingMessenger = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._messengers.size() == 0 && this._doUnavailableMessengerCheck && this._unavailableMessengers.size() > 0) {
                this.checkUnavailableMessengers();
            }
            while (!foundWorkingMessenger && this._messengers.size() > 0) {
                messenger = (IMessengerCommunication)this._messengers.removeFirst();
                boolean connected = false;
                try {
                    connected = messenger.isConnected();
                }
                finally {
                    if (!connected) {
                        if (this._log.isDebugEnabled()) {
                            this._log.error((Object)(messenger.getName() + " is not connected. Removing...."));
                        }
                        this._unavailableMessengers.addLast(messenger);
                        messenger = null;
                        continue;
                    }
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Using " + messenger.getName()));
                    }
                    this._messengers.addLast(messenger);
                    foundWorkingMessenger = true;
                }
            }
        }
        if (messenger == null) {
            throw new AdapterException("No working messenger connections found.");
        }
        return messenger;
    }

    private void checkUnavailableMessengers() {
        Iterator it = this._unavailableMessengers.iterator();
        while (it.hasNext()) {
            IMessengerCommunication messenger = (IMessengerCommunication)it.next();
            if (!messenger.isConnected()) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Successfully re-connected " + messenger.getName()));
            }
            this._messengers.addLast(messenger);
            it.remove();
        }
    }

    static {
        RESULT_KEY_MAPPING.put(XP_MESSAGE_RESULT_CODE, RESULT_PROPERTY_XP_CODE);
        RESULT_KEY_MAPPING.put(MAINTENANCE_MODE, RESULT_PROPERTY_MAINTENANCE_MODE);
        RESULT_KEY_MAPPING.put(NUMBER_SCHEMA_SETS, RESULT_PROPERTY_NUMBER_OF_SCHEMA_SETS);
        RESULT_KEY_MAPPING.put(SCHEMA_SET, RESULT_PROPERTY_SCHEMA_SET);
        RESULT_KEY_MAPPING.put(LOCAL_PARTNER_ID, RESULT_PROPERTY_LOCAL_PARTNER_ID);
        RESULT_KEY_MAPPING.put(REMOTE_PARTNER_ID, RESULT_PROPERTY_REMOTE_PARTNER_ID);
        RESULT_KEY_MAPPING.put(NUMBER_OF_AGREEMENTS, RESULT_PROPERTY_NUMBER_OF_AGREEMENTS);
        RESULT_KEY_MAPPING.put(AGREEMENT_LOCAL_PARTNER_ID, RESULT_PROPERTY_AGREEMENT_LOCAL_PARTNER_ID);
        RESULT_KEY_MAPPING.put(AGREEMENT_REMOTE_PARTNER_ID, RESULT_PROPERTY_AGREEMENT_REMOTE_PARTNER_ID);
        RESULT_KEY_MAPPING.put(NUMBER_OF_PARTNERS, RESULT_PROPERTY_NUMBER_OF_PARTNERS);
        RESULT_KEY_MAPPING.put(PARTNERID, RESULT_PROPERTY_PARTNERID);
        RESULT_KEY_MAPPING.put(PARTNER_CERTIFICATE, RESULT_PROPERTY_PARTNERCERTIFICATE);
        RESULT_KEY_MAPPING.put(MESSAGE_ID, RESULT_PROPERTY_MESSAGE_ID);
        RESULT_KEY_MAPPING.put(CONVERSATION_ID, RESULT_PROPERTY_CONVERSATION_ID);
        RESULT_KEY_MAPPING.put(MESSAGE_TYPE, RESULT_PROPERTY_MESSAGE_TYPE);
        RESULT_KEY_MAPPING.put(SCHEMA_VERSION, RESULT_PROPERTY_SCHEMA_VERSION);
        RESULT_KEY_MAPPING.put(MESSAGE_TIME, RESULT_PROPERTY_MESSAGE_TIME);
        RESULT_KEY_MAPPING.put(TRANSMISSION_PROTOCOL, RESULT_PROPERTY_TRANSMISSION_PROTOCOL);
    }
}

