/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="default-dump-routes")
public class DefaultDumpRoutesStrategy
extends ServiceSupport
implements DumpRoutesStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDumpRoutesStrategy.class);
    private static final String DIVIDER = "--------------------------------------------------------------------------------";
    private final AtomicInteger counter = new AtomicInteger();
    private CamelContext camelContext;
    private String include = "routes";
    private boolean resolvePlaceholders = true;
    private boolean uriAsParameters;
    private boolean generatedIds = true;
    private boolean log = true;
    private String output;
    private String outputFileName;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        String name = FileUtil.stripPath((String)this.output);
        if (name != null && name.contains(".")) {
            this.outputFileName = name;
            this.output = FileUtil.onlyPath((String)this.output);
            if (this.output == null || this.output.isEmpty()) {
                this.output = ".";
            }
        }
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isResolvePlaceholders() {
        return this.resolvePlaceholders;
    }

    public void setResolvePlaceholders(boolean resolvePlaceholders) {
        this.resolvePlaceholders = resolvePlaceholders;
    }

    public boolean isGeneratedIds() {
        return this.generatedIds;
    }

    public void setGeneratedIds(boolean generatedIds) {
        this.generatedIds = generatedIds;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isUriAsParameters() {
        return this.uriAsParameters;
    }

    public void setUriAsParameters(boolean uriAsParameters) {
        this.uriAsParameters = uriAsParameters;
    }

    public void dumpRoutes(String format) {
        if ("yaml".equalsIgnoreCase(format)) {
            this.doDumpRoutesAsYaml(this.camelContext);
        } else if ("xml".equalsIgnoreCase(format)) {
            this.doDumpRoutesAsXml(this.camelContext);
        }
    }

    protected void doDumpRoutesAsYaml(CamelContext camelContext) {
        RestsDefinition rests;
        RoutesDefinition def;
        RoutesDefinition routes;
        Resource resource2;
        StringBuilder sbLocal;
        Object sbLog;
        Object res;
        LinkedHashMap<Resource, Object> groups;
        int size;
        ModelToYAMLDumper dumper = PluginHelper.getModelToYAMLDumper((CamelContext)camelContext);
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        DummyResource dummy = new DummyResource(null, null);
        HashSet<String> files = new HashSet<String>();
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("beans")) && (size = model.getCustomBeans().size()) > 0) {
            List beans;
            groups = new LinkedHashMap<Resource, Object>();
            for (BeanFactoryDefinition beanFactoryDefinition : model.getCustomBeans()) {
                res = beanFactoryDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                beans = groups.computeIfAbsent((Resource)res, resource -> new ArrayList());
                beans.add(beanFactoryDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                beans = (List)entry.getValue();
                Resource resource22 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYamlBeans(camelContext, beans, resource22 == dummy ? null : resource22, dumper, "beans", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource22, sbLocal, "beans", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} beans as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("dataFormats")) && (size = model.getDataFormats().size()) > 0) {
            Map dfs;
            groups = new LinkedHashMap();
            for (Map.Entry entry : model.getDataFormats().entrySet()) {
                res = ((DataFormatDefinition)entry.getValue()).getResource();
                if (res == null) {
                    res = dummy;
                }
                dfs = groups.computeIfAbsent((Resource)res, resource -> new LinkedHashMap());
                dfs.put((String)entry.getKey(), (DataFormatDefinition)entry.getValue());
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                dfs = (Map)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYamlDataFormats(camelContext, dfs, resource2 == dummy ? null : resource2, dumper, "dataFormats", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "dataFormats", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} data formats as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routes")) && (size = model.getRouteDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteDefinition routeDefinition : model.getRouteDefinitions()) {
                if (routeDefinition.isRest() != null && routeDefinition.isRest().booleanValue() || routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue()) continue;
                res = routeDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RoutesDefinition());
                routes.getRoutes().add(routeDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RoutesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "routes", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "routes", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} routes as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeConfigurations") || this.include.contains("route-configurations")) && (size = model.getRouteConfigurationDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteConfigurationDefinition routeConfigurationDefinition : model.getRouteConfigurationDefinitions()) {
                res = routeConfigurationDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RouteConfigurationsDefinition());
                routes.getRouteConfigurations().add(routeConfigurationDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteConfigurationsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "route-configurations", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-configurations", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-configurations as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("rests")) && (size = model.getRestDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RestDefinition restDefinition : model.getRestDefinitions()) {
                res = restDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                rests = groups.computeIfAbsent((Resource)res, resource -> new RestsDefinition());
                rests.getRests().add(restDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RestsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "rests", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "rests", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} rests as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeTemplates") || this.include.contains("route-templates")) && (size = model.getRouteTemplateDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteTemplateDefinition routeTemplateDefinition : model.getRouteTemplateDefinitions()) {
                res = routeTemplateDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                rests = groups.computeIfAbsent((Resource)res, resource -> new RouteTemplatesDefinition());
                rests.getRouteTemplates().add(routeTemplateDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteTemplatesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpYaml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "route-templates", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-templates", "yaml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-templates as YAML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
    }

    protected void doDumpYaml(CamelContext camelContext, NamedNode def, Resource resource, ModelToYAMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpModelAsYaml(camelContext, def, this.resolvePlaceholders, this.uriAsParameters, this.generatedIds);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to YAML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpYamlBeans(CamelContext camelContext, List beans, Resource resource, ModelToYAMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpBeansAsYaml(camelContext, beans);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to YAML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpYamlDataFormats(CamelContext camelContext, Map dataFormats, Resource resource, ModelToYAMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpDataFormatsAsYaml(camelContext, dataFormats);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to YAML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpXmlDataFormats(CamelContext camelContext, Map dataFormats, Resource resource, ModelToXMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpDataFormatsAsXml(camelContext, dataFormats);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to XML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpRoutesAsXml(CamelContext camelContext) {
        RoutesDefinition def;
        RoutesDefinition routes;
        Resource resource2;
        StringBuilder sbLocal;
        Object sbLog;
        Object res;
        LinkedHashMap<Resource, Object> groups;
        int size;
        ModelToXMLDumper dumper = PluginHelper.getModelToXMLDumper((CamelContext)camelContext);
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        DummyResource dummy = new DummyResource(null, null);
        HashSet<String> files = new HashSet<String>();
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("beans")) && (size = model.getCustomBeans().size()) > 0) {
            List beans;
            groups = new LinkedHashMap<Resource, Object>();
            for (BeanFactoryDefinition beanFactoryDefinition : model.getCustomBeans()) {
                res = beanFactoryDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                beans = groups.computeIfAbsent((Resource)res, resource -> new ArrayList());
                beans.add(beanFactoryDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                beans = (List)entry.getValue();
                Resource resource22 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXmlBeans(camelContext, beans, resource22 == dummy ? null : resource22, dumper, "beans", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource22, sbLocal, "beans", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} beans as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("dataFormats")) && (size = model.getDataFormats().size()) > 0) {
            Map dfs;
            groups = new LinkedHashMap();
            for (Map.Entry entry : model.getDataFormats().entrySet()) {
                res = ((DataFormatDefinition)entry.getValue()).getResource();
                if (res == null) {
                    res = dummy;
                }
                dfs = groups.computeIfAbsent((Resource)res, resource -> new LinkedHashMap());
                dfs.put((String)entry.getKey(), (DataFormatDefinition)entry.getValue());
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                dfs = (Map)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXmlDataFormats(camelContext, dfs, resource2 == dummy ? null : resource2, dumper, "dataFormats", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "dataFormats", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} data formats as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routes")) && (size = model.getRouteDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteDefinition routeDefinition : model.getRouteDefinitions()) {
                if (routeDefinition.isRest() != null && routeDefinition.isRest().booleanValue() || routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue()) continue;
                res = routeDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RoutesDefinition());
                routes.getRoutes().add(routeDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RoutesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "route", "routes", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "routes", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} routes as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeConfigurations") || this.include.contains("route-configurations")) && (size = model.getRouteConfigurationDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteConfigurationDefinition routeConfigurationDefinition : model.getRouteConfigurationDefinitions()) {
                res = routeConfigurationDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RouteConfigurationsDefinition());
                routes.getRouteConfigurations().add(routeConfigurationDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteConfigurationsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "routeConfiguration", "route-configurations", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-configurations", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-configurations as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("rests")) && (size = model.getRestDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RestDefinition restDefinition : model.getRestDefinitions()) {
                res = restDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RestsDefinition());
                routes.getRests().add(restDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RestsDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "rest", "rests", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "rests", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} rests as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if ((this.include.contains("*") || this.include.contains("all") || this.include.contains("routeTemplates") || this.include.contains("route-templates")) && (size = model.getRouteTemplateDefinitions().size()) > 0) {
            groups = new LinkedHashMap();
            for (RouteTemplateDefinition routeTemplateDefinition : model.getRouteTemplateDefinitions()) {
                res = routeTemplateDefinition.getResource();
                if (res == null) {
                    res = dummy;
                }
                routes = groups.computeIfAbsent((Resource)res, resource -> new RouteTemplatesDefinition());
                routes.getRouteTemplates().add(routeTemplateDefinition);
            }
            sbLog = new StringBuilder();
            for (Map.Entry entry : groups.entrySet()) {
                def = (RouteTemplatesDefinition)entry.getValue();
                resource2 = (Resource)entry.getKey();
                sbLocal = new StringBuilder();
                this.doDumpXml(camelContext, (NamedNode)def, resource2 == dummy ? null : resource2, dumper, "routeTemplate", "route-templates", sbLocal, (StringBuilder)sbLog);
                this.doDumpToDirectory(resource2, sbLocal, "route-templates", "xml", files);
            }
            if (!sbLog.isEmpty() && this.log) {
                LOG.info("Dumping {} route-templates as XML", (Object)size);
                LOG.info("{}", sbLog);
            }
        }
        if (this.output != null && !files.isEmpty()) {
            this.doAdjustXmlFiles(files);
        }
    }

    protected void doDumpXmlBeans(CamelContext camelContext, List beans, Resource resource, ModelToXMLDumper dumper, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String dump = dumper.dumpBeansAsXml(camelContext, beans);
            sbLocal.append(dump);
            this.appendLogDump(resource, dump, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to XML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpXml(CamelContext camelContext, NamedNode def, Resource resource, ModelToXMLDumper dumper, String replace, String kind, StringBuilder sbLocal, StringBuilder sbLog) {
        try {
            String xml = dumper.dumpModelAsXml(camelContext, def, this.resolvePlaceholders, this.generatedIds);
            xml = StringHelper.replaceFirst((String)xml, (String)" xmlns=\"http://camel.apache.org/schema/spring\">", (String)">");
            xml = xml.replace("</" + (String)replace + ">", "</" + (String)replace + ">\n");
            replace = (String)replace + "s";
            xml = StringHelper.replaceFirst((String)xml, (String)("<" + (String)replace + ">"), (String)"");
            xml = StringHelper.replaceFirst((String)xml, (String)("</" + (String)replace + ">"), (String)"");
            sbLocal.append(xml);
            this.appendLogDump(resource, xml, sbLog);
        }
        catch (Exception e) {
            LOG.warn("Error dumping {}} to XML due to {}. This exception is ignored.", new Object[]{kind, e.getMessage(), e});
        }
    }

    protected void doDumpToDirectory(Resource resource, StringBuilder sbLocal, String kind, String ext, Set<String> files) {
        if (this.output != null && !sbLocal.isEmpty()) {
            File dir = new File(this.output);
            dir.mkdirs();
            String name = this.resolveFileName(ext, resource);
            boolean newFile = files.isEmpty() || !files.contains(name);
            File target = new File(this.output, name);
            try {
                if (newFile) {
                    IOHelper.writeText((String)sbLocal.toString(), (File)target);
                } else {
                    IOHelper.appendText((String)sbLocal.toString(), (File)target);
                }
                files.add(name);
                LOG.info("Dumped {} to file: {}", (Object)kind, (Object)target);
            }
            catch (IOException e) {
                throw new RuntimeException("Error dumping " + kind + " to file: " + String.valueOf(target), e);
            }
        }
    }

    protected void doAdjustXmlFiles(Set<String> files) {
        for (String name : files) {
            if (!name.endsWith(".xml")) continue;
            try {
                File file = new File(this.output, name);
                StringBuilder sb = new StringBuilder();
                sb.append("<camel>\n\n");
                String xml = IOHelper.loadText((InputStream)new FileInputStream(file));
                sb.append(xml);
                sb.append("\n</camel>\n");
                IOHelper.writeText((String)sb.toString(), (File)file);
            }
            catch (Exception e) {
                LOG.warn("Error adjusting dumped XML file: {} due to {}. This exception is ignored.", new Object[]{name, e.getMessage(), e});
            }
        }
    }

    protected void appendLogDump(Resource resource, String dump, StringBuilder sbLog) {
        String loc = null;
        if (resource != null) {
            loc = DefaultDumpRoutesStrategy.extractLocationName(resource.getLocation());
        }
        if (loc != null) {
            sbLog.append(String.format("%nSource: %s%n%s%n%s%n", loc, DIVIDER, dump));
        } else {
            sbLog.append(String.format("%n%n%s%n", dump));
        }
    }

    private static String extractLocationName(String loc) {
        if (loc == null) {
            return null;
        }
        if ((loc = LoggerHelper.stripSourceLocationLineNumber((String)loc)) != null && loc.contains(":")) {
            loc = StringHelper.after((String)loc, (String)":", (String)loc);
            loc = FileUtil.stripPath((String)loc);
        }
        return loc;
    }

    protected String resolveFileName(String ext, Resource resource) {
        Object name;
        if (this.outputFileName != null) {
            return this.outputFileName;
        }
        Object object = name = resource != null ? resource.getLocation() : null;
        if (name == null) {
            name = "dump" + this.counter.incrementAndGet();
        }
        if (((String)name).contains(":")) {
            name = StringHelper.after((String)name, (String)":");
        }
        return FileUtil.onlyName((String)name, (boolean)true) + "." + ext;
    }

    private static final class DummyResource
    extends ResourceSupport {
        private DummyResource(String scheme, String location) {
            super(scheme, location);
        }

        public boolean exists() {
            return true;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }
    }
}

