/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.security.MessageDigest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.xml.security.utils.resolver.ConcatKDFParameters;

public class ConcatKDFGenerator {
    private MessageDigest digest;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;

    public ConcatKDFGenerator(MessageDigest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestLength();
    }

    public void init(byte[] shared, String algorithmID, String partyUInfo, String partyVInfo, String suppPubInfo, String suppPrivInfo) throws IllegalArgumentException {
        this.shared = shared;
        StringBuilder sb = new StringBuilder();
        this.appendHexString(sb, algorithmID);
        this.appendHexString(sb, partyUInfo);
        this.appendHexString(sb, partyVInfo);
        this.appendHexString(sb, suppPubInfo);
        this.appendHexString(sb, suppPrivInfo);
        try {
            this.otherInfo = Hex.decodeHex((String)sb.toString());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void init(byte[] shared, ConcatKDFParameters concatKDFParameters) throws IllegalArgumentException {
        this.init(shared, concatKDFParameters.getAlgorithmId(), concatKDFParameters.getPartyUInfo(), concatKDFParameters.getPartyVInfo(), concatKDFParameters.getSuppPubInfo(), concatKDFParameters.getSuppPrivInfo());
    }

    private void appendHexString(StringBuilder sb, String hexString) {
        if (hexString != null && !hexString.trim().isEmpty()) {
            if (hexString.startsWith("00")) {
                sb.append(hexString.substring(2));
            } else {
                sb.append(hexString);
            }
        }
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    public int generateBytes(byte[] out, int outOff, int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        if (out.length - len < outOff) {
            throw new IllegalArgumentException("output buffer too small");
        }
        byte[] C = new byte[4];
        int counter = 1;
        int outputLen = 0;
        this.digest.reset();
        if (len > this.hLen) {
            do {
                this.ItoOSP(counter, C);
                this.digest.update(C, 0, C.length);
                this.digest.update(this.shared, 0, this.shared.length);
                this.digest.update(this.otherInfo, 0, this.otherInfo.length);
                System.arraycopy(this.digest.digest(), 0, out, outOff + outputLen, this.hLen);
                outputLen += this.hLen;
            } while (counter++ < len / this.hLen);
        }
        if (outputLen < len) {
            this.ItoOSP(counter, C);
            this.digest.update(C, 0, C.length);
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update(this.otherInfo, 0, this.otherInfo.length);
            System.arraycopy(this.digest.digest(), 0, out, outOff + outputLen, len - outputLen);
        }
        return len;
    }
}

