/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.velocity;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class SpringResourceLoader
extends ResourceLoader {
    public static final String NAME = "spring";
    public static final String SPRING_RESOURCE_LOADER_CLASS = "spring.resource.loader.class";
    public static final String SPRING_RESOURCE_LOADER_CACHE = "spring.resource.loader.cache";
    public static final String SPRING_RESOURCE_LOADER = "spring.resource.loader";
    public static final String SPRING_RESOURCE_LOADER_PATH = "spring.resource.loader.path";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String[] resourceLoaderPaths;
    ConfigResourceService resourceService;

    public void init(ExtProperties extProperties) {
        this.resourceService = (ConfigResourceService)extProperties.getProperty("configResourceService");
        this.setCachingOn(false);
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for Velocity resource with name [" + source + "]"));
        }
        try {
            return new InputStreamReader(this.resourceService.getResource(source).getValue(), encoding);
        }
        catch (IOException var8) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not find Velocity resource: " + source));
            }
            throw new ResourceNotFoundException("Could not find resource [" + source + "] in resource loader path");
        }
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

