/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import de.pontonconsulting.xmlpipe.soap.ebxml.MimeHeaderSkipInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.activation.DataSource;

public class SkipMimeHeaderDataSource
implements jakarta.activation.DataSource,
DataSource {
    private String _contentType;
    private String _name;
    private File _file;

    public SkipMimeHeaderDataSource(String contentType, String filename) throws FileNotFoundException {
        this(contentType, new File(filename));
    }

    public SkipMimeHeaderDataSource(String contentType, File file) throws FileNotFoundException {
        this._contentType = contentType;
        this._file = file;
        this._name = this._file.getName();
        if (this._file.exists()) {
            return;
        }
        throw new FileNotFoundException("File not found: " + this._file.getAbsolutePath());
    }

    public InputStream getInputStream() throws IOException {
        return new MimeHeaderSkipInputStream(new BufferedInputStream(Files.newInputStream(new File(this._name).toPath(), new OpenOption[0])));
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getName() {
        return this._name;
    }
}

