/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class Service {
    private String _value;
    private String _type;
    public static final String EBXML_SERVICE_TYPE = "type";

    public Service(String service, String type) {
        this._value = service;
        if (type != null && type.trim().length() > 0) {
            this._type = type;
        }
    }

    public Service(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        Name name = env.createName(EBXML_SERVICE_TYPE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        this._type = elem.getAttributeValue(name);
        this._value = elem.getValue();
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void generateSOAP(SOAPElement element, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        if (this._type != null) {
            name = envelope.createName(EBXML_SERVICE_TYPE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            element.addAttribute(name, this._type);
        }
        element.addTextNode(this._value);
    }

    public void validate() throws EbXmlException {
        if (this._type == null) {
            try {
                new URI(this._value);
            }
            catch (URISyntaxException e) {
                throw new EbXmlException(30042, "Error", "Inconsistent", "Service has to be a URI if no type is set");
            }
        }
    }
}

