/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

public class MessageOrder
extends HeaderExtension {
    private static final String CONTINUE = "Continue";
    private static final String RESET = "Reset";
    private boolean _reset;
    private String _sequenceNumber;
    public static final String EBXML_SEQUENCE_NUMBER = "SequenceNumber";
    private static final String EBXML_SEQUENCE_STATUS = "status";

    public MessageOrder(String sequenceNumber, boolean reset) {
        this._sequenceNumber = sequenceNumber;
        this._reset = reset;
    }

    public MessageOrder(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Iterator it = elem.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement) || !this.compare(name = (elem = (SOAPElement)subElement).getElementName(), EBXML_SEQUENCE_NUMBER)) continue;
            Name statusName = env.createName(EBXML_SEQUENCE_STATUS, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            String status = elem.getAttributeValue(statusName);
            this._reset = RESET.equals(status);
            this._sequenceNumber = elem.getValue();
            break;
        }
    }

    public String getSequenceNumber() {
        return this._sequenceNumber;
    }

    public boolean isSequenceReset() {
        return this._reset;
    }

    public void setSequenceNumber(String sequenceNumber, boolean reset) {
        this._sequenceNumber = sequenceNumber;
        this._reset = reset;
    }

    public void generateSOAP(SOAPHeaderElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        this.generateMustUnderstand(ebHeader, envelope);
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        name = envelope.createName(EBXML_SEQUENCE_NUMBER, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebSequence = ebHeader.addChildElement(name);
        Name statusName = envelope.createName(EBXML_SEQUENCE_STATUS, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        if (this._reset) {
            ebSequence.addAttribute(statusName, RESET);
        } else {
            ebSequence.addAttribute(statusName, CONTINUE);
        }
        ebSequence.addTextNode(this._sequenceNumber);
    }

    public void validate() throws EbXmlException {
        if (this._sequenceNumber == null) {
            throw new EbXmlException(30041, "Error", "OtherXml", "SequenceNumber Element missing in MessageOrder");
        }
    }
}

