/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

public class AckRequested
extends HeaderExtension {
    private String _actor;
    public static final String EBXML_ACTOR = "actor";
    private boolean _signed;
    public static final String EBXML_SIGNED = "signed";
    public static final String EBXML_SIGNED_TRUE = "true";
    public static final String EBXML_SIGNED_FALSE = "false";

    public AckRequested(boolean signed, String actor) {
        this._signed = signed;
        this._actor = actor;
    }

    public AckRequested(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Name name = env.createName(EBXML_ACTOR, "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        this._actor = elem.getAttributeValue(name);
        name = env.createName(EBXML_SIGNED, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        String signed = elem.getAttributeValue(name);
        this._signed = EBXML_SIGNED_TRUE.equals(signed);
    }

    public String getActor() {
        return this._actor;
    }

    public void setActor(String actor) {
        this._actor = actor;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public void setSigned(boolean signed) {
        this._signed = signed;
    }

    public void generateSOAP(SOAPHeaderElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        this.generateMustUnderstand(ebHeader, envelope);
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        if (this._actor != null) {
            name = envelope.createName(EBXML_ACTOR, "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            ebHeader.addAttribute(name, this._actor);
        } else {
            name = envelope.createName(EBXML_ACTOR, "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            ebHeader.addAttribute(name, "urn:oasis:names:tc:ebxml-msg:actor:toPartyMSH");
        }
        name = envelope.createName(EBXML_SIGNED, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        if (this._signed) {
            ebHeader.addAttribute(name, EBXML_SIGNED_TRUE);
        } else {
            ebHeader.addAttribute(name, EBXML_SIGNED_FALSE);
        }
    }
}

