/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.body;

import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.BodyExtension;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class Manifest
extends BodyExtension {
    private final ArrayList<String> _cids = new ArrayList();
    private final ArrayList<Reference> _reference = new ArrayList();
    public static final String EBXML_REFERENCE = "Reference";

    public Manifest() {
    }

    public Manifest(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Iterator it = elem.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement) || !this.compare(name = (elem = (SOAPElement)subElement).getElementName(), EBXML_REFERENCE)) continue;
            Reference ref = new Reference(elem, env);
            this._cids.add(ref.getXlinkHref());
            this._reference.add(ref);
        }
    }

    public ArrayList<Reference> getReferences() {
        return this._reference;
    }

    public void addReference(Reference reference) {
        if (!this._cids.contains(reference.getXlinkHref())) {
            this._cids.add(reference.getXlinkHref());
            this._reference.add(reference);
        }
    }

    public Reference getReference(String cid) {
        int index = this._cids.indexOf(cid);
        if (index != -1) {
            return this._reference.get(index);
        }
        return null;
    }

    public void generateSOAP(SOAPBodyElement ebBody, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebBody.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebBody.addAttribute(name, this.getVersion());
        Iterator<Reference> i = this._reference.iterator();
        while (i.hasNext()) {
            name = envelope.createName(EBXML_REFERENCE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebReference = ebBody.addChildElement(name);
            Reference element = i.next();
            element.generateSOAP(ebReference, envelope);
        }
    }

    public void validate() throws EbXmlException {
        if (this._reference.isEmpty()) {
            throw new EbXmlException(30024, "Error", "OtherXml", "Manifest must have at least one Reference");
        }
    }
}

