/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml;

import java.io.IOException;
import java.io.InputStream;

public class MimeHeaderSkipInputStream
extends InputStream {
    private final byte[] _buffer;
    private int _offset = 0;
    private int _bytesInBuffer = 0;
    private final InputStream _in;
    private boolean _headerSkipped = false;

    public MimeHeaderSkipInputStream(InputStream in) {
        this(in, 16384);
    }

    public MimeHeaderSkipInputStream(InputStream in, int bufferSize) {
        this._in = in;
        this._buffer = new byte[16384];
    }

    @Override
    public int read() throws IOException {
        if (this._offset == this._bytesInBuffer) {
            this.fetchData();
        }
        if (this._bytesInBuffer != -1) {
            return this._buffer[this._offset++] & 0xFF;
        }
        return -1;
    }

    private void fetchData() throws IOException {
        this._offset = 0;
        this._bytesInBuffer = this._in.read(this._buffer);
        if (!this._headerSkipped) {
            for (int i = 0; i < this._buffer.length - 4 && !this._headerSkipped; ++i) {
                if (this._buffer[i] != 13 || this._buffer[i + 1] != 10 || this._buffer[i + 2] != 13 || this._buffer[i + 3] != 10) continue;
                this._offset = i + 4;
                this._headerSkipped = true;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }
}

