/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.xmlsig.SignException;
import de.pontonconsulting.xmlpipe.security.xmlsig.VerifyException;
import de.pontonconsulting.xmlpipe.soap.ebxml.AttachmentInfo;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.MimeHeaderSkipInputStream;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.Manifest;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.Reference;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.Schema;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.StatusRequest;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.StatusResponse;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.AckRequested;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Acknowledgment;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Description;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.DigitalSignatureReference;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Error;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.ErrorList;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.MessageHeader;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.MessageOrder;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.ProcessingDirectives;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.SyncReply;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class EbXmlMessage {
    private static final String BINARY = "binary";
    private static final String TRUE = "true";
    private static final String TEXT_XML__CHARSET_UTF_8 = "text/xml; charset=utf-8";
    private static final String EBXML = "\"ebXML\"";
    private static final String SOAP_ACTION = "SOAPAction";
    public static final String EBXML_ENVELOPE_FILE = "packaging_envelope.xml";
    public static final String EB_NS_URI = "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd";
    public static final String EB_NS_PREFIX = "eb";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static final String XLINK_NS_PREFIX = "xlink";
    public static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String DS_NS_PREFIX = "ds";
    public static final String DS_NS_URI = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SOAPENV_NS_PREFIX = "soapenv";
    public static final String SOAPENV_NS_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XP_NS_URI = "http://www.ponton-consulting.de/xmlpipe/processing-directives";
    public static final String XP_NS_PREFIX = "xp";
    public static final String EBXML_MESSAGEHEADER = "MessageHeader";
    public static final String EBXML_SYNC_REPLY = "SyncReply";
    public static final String EBXML_MESSAGE_ORDER = "MessageOrder";
    public static final String EBXML_ACK_REQUESTED = "AckRequested";
    public static final String EBXML_ACKNOWLEDGEMENT = "Acknowledgment";
    public static final String EBXML_ERRORLIST = "ErrorList";
    public static final String EBXML_SIGNATURE = "Signature";
    private static final String EBXML_MESSAGE_ERROR = "MessageError";
    public static final String EBXML_PROCESSING = "ProcessingDirectives";
    public static final String EBXML_MANIFEST = "Manifest";
    public static final String EBXML_STATUS_REQUEST = "StatusRequest";
    public static final String EBXML_STATUS_RESPONSE = "StatusResponse";
    public static final String EBXML_MSG_SERVICE = "urn:oasis:names:tc:ebxml-msg:service";
    public static final String EBXML_PONG = "Pong";
    public static final String EBXML_PING = "Ping";
    private final SOAPMessage _message;
    private MessageHeader _messageHeader;
    private Manifest _manifest;
    private SyncReply _syncReply;
    private MessageOrder _messageOrder;
    private Acknowledgment _acknowledgement;
    private AckRequested _ackRequested;
    private ErrorList _errorList;
    private StatusResponse _statusResponse;
    private StatusRequest _statusRequest;
    private DigitalSignatureReference _signature;
    private ProcessingDirectives _processing;
    private Reference _currentReference;
    private Error _currentError;
    private File _ebXmlEnvelopeFile;
    private String _transferEncoding = "binary";
    private final ArrayList<AttachmentInfo> _attachmentInfos = new ArrayList();
    private final ArrayList<InputStream> _attachmentStreams = new ArrayList();
    private final ReferenceDateTask referenceDateTask;

    public EbXmlMessage(SOAPMessage message, ReferenceDateTask referenceDateTask) throws SOAPException {
        this._message = message;
        this.referenceDateTask = referenceDateTask;
        SOAPPart sp = this._message.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hdr = env.getHeader();
        SOAPBody body = env.getBody();
        Iterator it = hdr.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object temp = it.next();
            if (!(temp instanceof SOAPHeaderElement)) continue;
            SOAPHeaderElement elem = (SOAPHeaderElement)temp;
            name = elem.getElementName();
            if (this.compare(name, EBXML_MESSAGEHEADER, EB_NS_URI)) {
                this._messageHeader = new MessageHeader((SOAPElement)elem, env, referenceDateTask);
                continue;
            }
            if (this.compare(name, EBXML_SYNC_REPLY, EB_NS_URI)) {
                this._syncReply = new SyncReply((SOAPElement)elem, env);
                continue;
            }
            if (this.compare(name, EBXML_MESSAGE_ORDER, EB_NS_URI)) {
                this._messageOrder = new MessageOrder((SOAPElement)elem, env);
                continue;
            }
            if (this.compare(name, EBXML_ACK_REQUESTED, EB_NS_URI)) {
                this._ackRequested = new AckRequested((SOAPElement)elem, env);
                continue;
            }
            if (this.compare(name, EBXML_ACKNOWLEDGEMENT, EB_NS_URI)) {
                this._acknowledgement = new Acknowledgment((SOAPElement)elem, env);
                continue;
            }
            if (this.compare(name, EBXML_ERRORLIST, EB_NS_URI)) {
                this._errorList = new ErrorList((SOAPElement)elem, env);
                continue;
            }
            if (this.compare(name, EBXML_SIGNATURE, DS_NS_URI)) {
                this._signature = new DigitalSignatureReference((SOAPElement)elem, env);
                continue;
            }
            if (!elem.getMustUnderstand()) {
                this._processing = new ProcessingDirectives((SOAPElement)elem, env);
                continue;
            }
            throw new SOAPException(elem.getLocalName() + " is an unknown SOAP-Header, processing aborted.");
        }
        if (this._messageOrder != null && this._syncReply != null) {
            this._syncReply = null;
        }
        it = body.getChildElements();
        SOAPBodyElement bodyElem = null;
        while (it.hasNext()) {
            Object temp = it.next();
            if (!(temp instanceof SOAPBodyElement)) continue;
            bodyElem = (SOAPBodyElement)temp;
            name = bodyElem.getElementName();
            if (this.compare(name, EBXML_MANIFEST, EB_NS_URI)) {
                this._manifest = new Manifest((SOAPElement)bodyElem, env);
                continue;
            }
            if (this.compare(name, EBXML_STATUS_REQUEST, EB_NS_URI)) {
                this._statusRequest = new StatusRequest((SOAPElement)bodyElem, env);
                continue;
            }
            if (!this.compare(name, EBXML_STATUS_RESPONSE, EB_NS_URI)) continue;
            this._statusResponse = new StatusResponse((SOAPElement)bodyElem, env);
        }
    }

    public void prepareMinimalMessage() {
        this._messageHeader = new MessageHeader(this.referenceDateTask);
    }

    public void preparePingMessage() {
        this.prepareMinimalMessage();
        this._messageHeader.setService(EBXML_MSG_SERVICE, null);
        this._messageHeader.setAction(EBXML_PING);
    }

    public void preparePongMessage(String pingReference) {
        this.prepareMinimalMessage();
        this._messageHeader.setService(EBXML_MSG_SERVICE, null);
        this._messageHeader.setAction(EBXML_PONG);
        this._messageHeader.getMessageData().setRefToMessageId(pingReference);
    }

    public void prepareAcknowledgment(String messageRefId, Date date, List<SOAPElement> nodeList) {
        this.prepareMinimalMessage();
        this._messageHeader.setService(EBXML_MSG_SERVICE, null);
        this._messageHeader.setAction(EBXML_ACKNOWLEDGEMENT);
        this._messageHeader.getMessageData().setRefToMessageId(messageRefId);
        this._messageHeader.setDuplicateElimination(true);
        this.setAcknowledgment(date, messageRefId, nodeList);
    }

    public void prepareErrorMessage(String messageRefId) {
        this.prepareMinimalMessage();
        this._messageHeader.setService(EBXML_MSG_SERVICE, null);
        this._messageHeader.setAction(EBXML_MESSAGE_ERROR);
        this._messageHeader.getMessageData().setRefToMessageId(messageRefId);
        this._messageHeader.setDuplicateElimination(true);
    }

    public void prepareStatusResponseMessage(String statusRequestId) {
        this.prepareMinimalMessage();
        this._messageHeader.setService(EBXML_MSG_SERVICE, null);
        this._messageHeader.setAction(EBXML_STATUS_RESPONSE);
        this._messageHeader.getMessageData().setRefToMessageId(statusRequestId);
    }

    public void setService(String service, String type) {
        this._messageHeader.setService(service, type);
    }

    public String getService() {
        try {
            return this._messageHeader.getService().getValue();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getSchemaLocationForPayloadRole(String requestedRole) {
        String location = null;
        if (this._manifest != null) {
            ArrayList<Reference> temp = this._manifest.getReferences();
            for (Reference element : temp) {
                Collection<Schema> temp2;
                Iterator<Schema> iter2;
                String role = element.getXlinkRole();
                if (!requestedRole.equalsIgnoreCase(role) || !(iter2 = (temp2 = element.getSchemas()).iterator()).hasNext()) continue;
                Schema schema = iter2.next();
                location = schema.getLocation();
            }
        }
        return location;
    }

    public String getServiceType() {
        return this._messageHeader.getService().getType();
    }

    public void setAction(String action) {
        this._messageHeader.setAction(action);
    }

    public String getAction() {
        return this._messageHeader.getAction();
    }

    public void setConversationId(String conversationId) {
        this._messageHeader.setConversationId(conversationId);
    }

    public String getConversationId() {
        return this._messageHeader.getConversationId();
    }

    public void setCPAId(String cpaId) {
        this._messageHeader.setCpaId(cpaId);
    }

    public String getCPAId() {
        return this._messageHeader.getCpaId();
    }

    public void setFromIds(HashMap<String, String> fromParties) {
        this._messageHeader.setFrom(fromParties);
    }

    public void addFromId(String partyId, String idType) {
        this._messageHeader.getFrom().addPartyId(partyId, idType);
    }

    public String getFromId(String type) {
        return this._messageHeader.getFrom().getPartyIds().get(type);
    }

    public HashMap<String, String> getFromIds() {
        return this._messageHeader.getFrom().getPartyIds();
    }

    public void setFromRole(String role) {
        this._messageHeader.getFrom().setRole(role);
    }

    public String getFromRole() {
        return this._messageHeader.getFrom().getRole();
    }

    public void setToIds(HashMap<String, String> toParties) {
        this._messageHeader.setTo(toParties);
    }

    public void addToId(String partyId, String idType) {
        this._messageHeader.getTo().addPartyId(partyId, idType);
    }

    public String getToId(String type) {
        return this._messageHeader.getTo().getPartyIds().get(type);
    }

    public HashMap<String, String> getToIds() {
        return this._messageHeader.getTo().getPartyIds();
    }

    public void setToRole(String role) {
        this._messageHeader.getTo().setRole(role);
    }

    public String getToRole() {
        return this._messageHeader.getTo().getRole();
    }

    public void setMessageId(String id) {
        this._messageHeader.getMessageData().setMessageId(id);
    }

    public String getMessageId() {
        return this._messageHeader.getMessageData().getMessageId();
    }

    public String getRefToMessageId() {
        return this._messageHeader.getMessageData().getRefToMessageId();
    }

    public void setMessageTimestamp(Date UTCdate) {
        this._messageHeader.getMessageData().setTimestamp(UTCdate);
    }

    public Date getMessageTimestamp() {
        return this._messageHeader.getMessageData().getTimestamp();
    }

    public Date getTimeToLive() {
        return this._messageHeader.getMessageData().getTimeToLive();
    }

    public void setTimeToLive(Date timeToLive) {
        this._messageHeader.getMessageData().setTimeToLive(timeToLive);
    }

    public void addMessageDescription(String text, String language) {
        this._messageHeader.addDescription(text, language);
    }

    public void setDuplicateElimination(boolean flag) {
        this._messageHeader.setDuplicateElimination(flag);
    }

    public boolean isDuplicateElmination() {
        return this._messageHeader.isDuplicateElimination();
    }

    public void addAttachment(String contentId, String contentType, File contentFile) throws IOException {
        this.addAttachment(contentId, contentType, contentFile, contentFile.getName());
    }

    public void addAttachment(String contentId, String contentType, File contentFile, String fileName) throws IOException {
        String newFilename;
        try {
            newFilename = MimeUtility.encodeText((String)fileName);
        }
        catch (UnsupportedEncodingException ex) {
            newFilename = fileName;
        }
        AttachmentPart ap = this._message.createAttachmentPart();
        ap.setContentId(contentId);
        if (contentType != null && contentType.length() > 0 && contentType.toLowerCase().startsWith("multipart")) {
            BufferedInputStream attachmentStream = new BufferedInputStream(Files.newInputStream(contentFile.toPath(), new OpenOption[0]));
            MimeHeaderSkipInputStream skipStream = new MimeHeaderSkipInputStream(attachmentStream);
            ap.setContent((Object)skipStream, contentType);
            ap.setMimeHeader("Content-Disposition", "attachment; filename=\"" + newFilename + "\"");
            this._attachmentStreams.add(skipStream);
        } else {
            ap.setMimeHeader("Content-Disposition", "attachment; filename=\"" + newFilename + "\"");
            ap.setMimeHeader("Content-Transfer-Encoding", this._transferEncoding);
            ap.setDataHandler(new DataHandler((DataSource)new SimpleFileDataSource(contentType, contentFile)));
        }
        this._message.addAttachmentPart(ap);
    }

    public void addReference(String contentId, String role) throws URISyntaxException {
        if (this._manifest == null) {
            this._manifest = new Manifest();
        }
        URI href = new URI("cid", contentId, null);
        Reference temp = new Reference(href.toASCIIString(), role, "simple");
        this._manifest.addReference(temp);
        this._currentReference = temp;
    }

    public void addSchemaToCurrentReference(String location, String version) {
        this._currentReference.addSchema(location, version);
    }

    public void addDescriptionToCurrentReference(String text, String language) {
        this._currentReference.addDescription(text, language);
    }

    public void addError(String severity, String errorcode, String location) {
        if (this._errorList == null) {
            this._errorList = new ErrorList();
        }
        Error temp = new Error(severity, errorcode, location);
        this._errorList.addError(temp);
        this._currentError = temp;
    }

    public String getHighestSeverityOfError() {
        String result = null;
        if (this._errorList != null) {
            result = this._errorList.getHighestSeverity();
        }
        return result;
    }

    public Collection<Error> getErrors() {
        Collection<Error> result = null;
        if (this._errorList != null) {
            result = this._errorList.getErrors();
        }
        return result;
    }

    public void setDescriptionToCurrentError(String text, String language) {
        this._currentError.setDescription(text, language);
    }

    public void setSyncReply(boolean flag) {
        if (flag) {
            if (this._syncReply == null) {
                this._syncReply = new SyncReply();
            }
        } else {
            this._syncReply = null;
        }
    }

    public boolean hasSyncReply() {
        return this._syncReply != null;
    }

    public void setStatusRequest(String refToMessageId) {
        if (this._statusRequest == null) {
            this._statusRequest = new StatusRequest(refToMessageId);
        } else {
            this._statusRequest.setRefToMessageId(refToMessageId);
        }
    }

    public void setStatusResponse(String refToMessageId, String status, Date timestamp) {
        if (this._statusResponse == null) {
            this._statusResponse = new StatusResponse(refToMessageId, status, timestamp);
        } else {
            this._statusResponse.setRefToMessageId(refToMessageId);
            this._statusResponse.setTimestamp(timestamp);
            this._statusResponse.setMessageStatus(status);
        }
    }

    public void setSequenceNumber(String number, boolean reset) {
        if (this._messageOrder == null) {
            this._messageOrder = new MessageOrder(number, reset);
        } else {
            this._messageOrder.setSequenceNumber(number, reset);
        }
    }

    public int getSequenceNumber() {
        int result = -1;
        if (this._messageOrder != null) {
            try {
                String number = this._messageOrder.getSequenceNumber();
                result = Integer.valueOf(number);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isSequenceReset() {
        boolean result = false;
        if (this._messageOrder != null) {
            result = this._messageOrder.isSequenceReset();
        }
        return result;
    }

    public void setAckRequested(boolean signed, String actor) {
        if (this._ackRequested == null) {
            this._ackRequested = new AckRequested(signed, actor);
        } else {
            this._ackRequested.setActor(actor);
            this._ackRequested.setSigned(signed);
        }
    }

    public boolean isSyncReplyRequested() {
        return this._syncReply != null;
    }

    public boolean isAckRequested() {
        return this._ackRequested != null;
    }

    public boolean isSignedAckRequested() {
        if (this._ackRequested != null) {
            return this._ackRequested.isSigned();
        }
        return false;
    }

    public boolean isSigned() {
        return this._signature != null;
    }

    public void setAcknowledgment(Date timestamp, String refToMessageId, List<SOAPElement> signatureReferences) {
        if (this._acknowledgement == null) {
            this._acknowledgement = new Acknowledgment(timestamp, refToMessageId, signatureReferences);
        } else {
            this._acknowledgement.setRefToMessageId(refToMessageId);
            this._acknowledgement.setTimestamp(timestamp);
        }
    }

    public void addAcknowledgmentFromId(String partyId, String idType) {
        this._acknowledgement.addFromPartyId(partyId, idType);
    }

    public String getAcknowledgementReference() {
        String result = null;
        if (this._acknowledgement != null) {
            result = this._acknowledgement.getRefToMessageId();
        }
        return result;
    }

    public String getStatusRequestReference() {
        String result = null;
        if (this._statusRequest != null) {
            result = this._statusRequest.getRefToMessageId();
        }
        return result;
    }

    public String getStatusResponseMSGReference() {
        String result = null;
        if (this._statusResponse != null) {
            result = this._statusResponse.getRefToMessageId();
        }
        return result;
    }

    public String getMessageStatus() {
        String result = null;
        if (this._statusResponse != null) {
            result = this._statusResponse.getMessageStatus();
        }
        return result;
    }

    public Date getStatusResponseMSGTimestamp() {
        Date result = null;
        if (this._statusResponse != null) {
            result = this._statusResponse.getTimestamp();
        }
        return result;
    }

    public Date getAcknowledgementTimestamp() {
        Date result = null;
        if (this._acknowledgement != null) {
            result = this._acknowledgement.getTimestamp();
        }
        return result;
    }

    public boolean hasAttachments() {
        return this._message.countAttachments() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachmentsToDisk(File messageFolder) throws IOException, SOAPException {
        messageFolder.mkdirs();
        for (AttachmentInfo attachmentInfo : this._attachmentInfos) {
            OutputStream fos = null;
            InputStream is = null;
            try {
                String filename = null;
                filename = attachmentInfo.isPayload() ? "payload.dat" : (attachmentInfo.isSignature() ? "payload.sig" : this.getFilenameForAttachment(attachmentInfo));
                File location = new File(messageFolder, filename);
                if (!(attachmentInfo.isPayload() || attachmentInfo.isSignature() || "attachments".equals(messageFolder.getName()))) {
                    File attachmentFolder = new File(messageFolder, "attachments");
                    attachmentFolder.mkdir();
                    location = new File(attachmentFolder, filename);
                }
                fos = new BufferedOutputStream(Files.newOutputStream(location.toPath(), new OpenOption[0]), 16384);
                if (attachmentInfo.getContentType().toLowerCase().startsWith("multipart")) {
                    attachmentInfo.writeTo(fos);
                } else {
                    is = new BufferedInputStream(attachmentInfo.getInputStream(), 16384);
                    int eof = 0;
                    while ((eof = is.read()) > -1) {
                        fos.write(eof);
                    }
                }
                attachmentInfo.setLocalFile(location);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getFilenameForAttachment(AttachmentInfo attachmentInfo) {
        String contentId;
        String filename = null;
        ContentDisposition contentDisposition = attachmentInfo.getContentDisposition();
        if (contentDisposition != null) {
            filename = contentDisposition.getParameter("filename");
        }
        if (StringUtils.isBlank(filename) && (contentId = attachmentInfo.getContentId()).startsWith("<")) {
            filename = contentId.replace('<', ' ').replace('>', ' ').trim();
        }
        return filename;
    }

    public void saveEbXmlToDisk(File messageFolder) throws IOException, SOAPException {
        messageFolder.mkdirs();
        File ebxmlEnvelopeFile = new File(messageFolder, EBXML_ENVELOPE_FILE);
        try (OutputStream fos = null;){
            this.getMessage();
            fos = new BufferedOutputStream(Files.newOutputStream(ebxmlEnvelopeFile.toPath(), new OpenOption[0]));
            SOAPMessage msg = this.getOriginalMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)TRUE);
            msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            ArrayList<AttachmentPart> attachments = new ArrayList<AttachmentPart>();
            Iterator iter = msg.getAttachments();
            while (iter.hasNext()) {
                attachments.add((AttachmentPart)iter.next());
            }
            msg.removeAllAttachments();
            msg.saveChanges();
            this.getOriginalMessage().writeTo(fos);
            for (int i = 0; i < attachments.size(); ++i) {
                AttachmentPart temp = (AttachmentPart)attachments.get(i);
                msg.addAttachmentPart(temp);
            }
            msg.saveChanges();
            this._ebXmlEnvelopeFile = ebxmlEnvelopeFile;
        }
    }

    public SOAPMessage getOriginalMessage() {
        return this._message;
    }

    public SOAPMessage getMessage() throws SOAPException {
        Iterator i;
        if (this._message != null && !(i = this._message.getSOAPPart().getEnvelope().getHeader().getChildElements()).hasNext()) {
            this.generateMessage();
        }
        return this._message;
    }

    public SOAPMessage generateMessage() throws SOAPException {
        SOAPBodyElement ebBody;
        SOAPHeaderElement ebHeader;
        MimeHeaders headers = this._message.getMimeHeaders();
        headers.setHeader(SOAP_ACTION, EBXML);
        SOAPPart sp = this._message.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        sp.setMimeHeader("Content-ID", "<EbXml-Envelope-" + System.currentTimeMillis() + ">");
        if (this._messageHeader != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_MESSAGEHEADER, EB_NS_PREFIX, EB_NS_URI));
            this._messageHeader.generateSOAP(ebHeader, envelope);
        }
        if (this._errorList != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_ERRORLIST, EB_NS_PREFIX, EB_NS_URI));
            this._errorList.generateSOAP(ebHeader, envelope);
        }
        if (this._syncReply != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_SYNC_REPLY, EB_NS_PREFIX, EB_NS_URI));
            this._syncReply.generateSOAP(ebHeader, envelope);
        }
        if (this._messageOrder != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_MESSAGE_ORDER, EB_NS_PREFIX, EB_NS_URI));
            this._messageOrder.generateSOAP(ebHeader, envelope);
        }
        if (this._ackRequested != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_ACK_REQUESTED, EB_NS_PREFIX, EB_NS_URI));
            this._ackRequested.generateSOAP(ebHeader, envelope);
        }
        if (this._acknowledgement != null) {
            ebHeader = header.addHeaderElement(envelope.createName(EBXML_ACKNOWLEDGEMENT, EB_NS_PREFIX, EB_NS_URI));
            this._acknowledgement.generateSOAP(ebHeader, envelope);
        }
        if (this._processing != null) {
            this._processing.generateSOAP(header, envelope);
        }
        if (this._manifest != null) {
            ebBody = body.addBodyElement(envelope.createName(EBXML_MANIFEST, EB_NS_PREFIX, EB_NS_URI));
            this._manifest.generateSOAP(ebBody, envelope);
        }
        if (this._statusRequest != null) {
            ebBody = body.addBodyElement(envelope.createName(EBXML_STATUS_REQUEST, EB_NS_PREFIX, EB_NS_URI));
            this._statusRequest.generateSOAP(ebBody, envelope);
        }
        if (this._statusResponse != null) {
            ebBody = body.addBodyElement(envelope.createName(EBXML_STATUS_RESPONSE, EB_NS_PREFIX, EB_NS_URI));
            this._statusResponse.generateSOAP(ebBody, envelope);
        }
        this._message.getSOAPPart().setMimeHeader("Content-Transfer-Encoding", this._transferEncoding);
        this._message.getSOAPPart().setMimeHeader("Content-Type", TEXT_XML__CHARSET_UTF_8);
        return this._message;
    }

    public void validate() throws EbXmlException {
        if (this._messageHeader == null) {
            throw new EbXmlException(30001, "Error", "OtherXml", "MessageHeader Element is required.");
        }
        this._messageHeader.validate();
        if (this._manifest != null) {
            this._manifest.validate();
        }
        if (this._syncReply != null) {
            this._syncReply.validate();
        }
        if (this._messageOrder != null) {
            this._messageOrder.validate();
        }
        if (this._ackRequested != null) {
            if (this._errorList != null) {
                throw new EbXmlException(30002, "Error", "OtherXml", "AckRequested must not be present in an ErrorMessage.");
            }
            if (this._message.countAttachments() == 0 && this._acknowledgement != null) {
                throw new EbXmlException(30003, "Error", "OtherXml", "AckRequested must not be present with only an Acknowledgment and no Payload.");
            }
        }
        if (this._acknowledgement != null) {
            this._acknowledgement.validate();
        }
        if (this._errorList != null) {
            this._errorList.validate();
        }
        if (this._messageOrder != null) {
            this._messageOrder.validate();
            if (this._syncReply != null) {
                throw new EbXmlException(30003, "Error", "Inconsistent", "Message Ordering must not be used with SyncReply.");
            }
            if (!this.isDuplicateElmination()) {
                throw new EbXmlException(30003, "Error", "Inconsistent", "Message Ordering requires use of duplicate elimination.");
            }
            if (this._ackRequested == null) {
                throw new EbXmlException(30003, "Error", "Inconsistent", "Message Ordering requires use of reliable messaging (RequestAcknowledgement).");
            }
        }
        if (this._statusRequest != null) {
            if (this._errorList != null || this._manifest != null || this._statusResponse != null) {
                throw new EbXmlException(30004, "Error", "OtherXml", "StatusRequest must not be present with either an ErrorList, Manifest or StatusResponse.");
            }
            this._statusRequest.validate();
        }
        if (this._statusResponse != null) {
            if (this._manifest != null || this._statusRequest != null) {
                throw new EbXmlException(30005, "Error", "OtherXml", "StatusResponse must not be present with either a Manifest or StatusRequest.");
            }
            if (this._errorList != null && this._errorList.getHighestSeverity().equals("Error")) {
                throw new EbXmlException(30006, "Error", "OtherXml", "StatusRequest must not be present with an an ErrorList element with a highestSeverity attribute set to Error.");
            }
            this._statusResponse.validate();
        }
        if (this._manifest != null) {
            this._manifest.validate();
            ArrayList<Reference> references = this._manifest.getReferences();
            for (Reference ref : references) {
                String refKey = ref.getXlinkHref();
                try {
                    URI cid = new URI(refKey);
                    if (!cid.getScheme().equalsIgnoreCase("cid")) continue;
                    boolean found = false;
                    Iterator iter2 = this._message.getAttachments();
                    while (iter2.hasNext()) {
                        AttachmentPart attachment = (AttachmentPart)iter2.next();
                        String id = attachment.getContentId();
                        if (id != null) {
                            id = id.replace('<', ' ');
                            id = id.replace('>', ' ');
                            id = id.trim();
                        }
                        if (id == null || !id.equals(cid.getSchemeSpecificPart())) continue;
                        ArrayList<String> descriptions = new ArrayList<String>();
                        ArrayList<String> descriptionLanguages = new ArrayList<String>();
                        ArrayList<String> schemaLocations = new ArrayList<String>();
                        ArrayList<String> schemaVersions = new ArrayList<String>();
                        Reference tempReference = this._manifest.getReference(refKey);
                        for (Schema element : tempReference.getSchemas()) {
                            schemaLocations.add(element.getLocation());
                            schemaVersions.add(element.getVersion());
                        }
                        for (Description element : tempReference.getDescriptions()) {
                            descriptions.add(element.getValue());
                            descriptionLanguages.add(element.getLang());
                        }
                        AttachmentInfo temp = new AttachmentInfo();
                        temp.setAttachmentPart(attachment);
                        temp.setDescriptions(descriptions.toArray(new String[descriptions.size()]));
                        temp.setSchemaLocations(schemaLocations.toArray(new String[schemaLocations.size()]));
                        temp.setSchemaVersions(schemaVersions.toArray(new String[schemaVersions.size()]));
                        temp.setDescriptionLanguages(schemaVersions.toArray(new String[schemaVersions.size()]));
                        temp.setRole(tempReference.getXlinkRole());
                        this._attachmentInfos.add(temp);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new EbXmlException(30007, new String[]{String.valueOf(cid)}, "Error", "MimeProblem", "Attachment with content-id: " + String.valueOf(cid) + " is missing");
                }
                catch (URISyntaxException e) {
                    throw new EbXmlException(30045, new String[]{refKey, e.getMessage()}, "Error", "MimeProblem", "invalid CID format '" + refKey + "' " + e.getMessage());
                }
            }
        }
    }

    public AttachmentInfo[] getAttachmentInfo() {
        return this._attachmentInfos.toArray(new AttachmentInfo[this._attachmentInfos.size()]);
    }

    public void setProcessingDirectives(Map<String, String> map) {
        this._processing = new ProcessingDirectives(new HashMap<String, String>(map));
    }

    public HashMap<String, String> getProcessingDirectives() {
        if (this._processing != null) {
            return this._processing.getDirectives();
        }
        return null;
    }

    public void sign(PrivateKey privateKey, Certificate[] certificateChain) throws SignException, SOAPException {
        this.generateMessage();
        if (this._message != null) {
            SOAPPart sp = this._message.getSOAPPart();
            sp.getEnvelope();
            this._signature = new DigitalSignatureReference(this._message, privateKey, certificateChain);
            this._signature.generateSOAP();
        }
    }

    public boolean verifySignature(PublicKey publicKey) throws ParserConfigurationException, SAXException, SignException, VerifyException, IOException, SOAPException {
        if (this._signature == null) {
            return true;
        }
        return this._signature.verifySignature(this._ebXmlEnvelopeFile, this._attachmentInfos.iterator(), publicKey);
    }

    public List<SOAPElement> getSignatureReferences() {
        return this._signature.getSignatureReferences();
    }

    public Certificate extractSenderCertificate() {
        try {
            if (this._signature != null) {
                return this._signature.extractSenderCertificate(this._ebXmlEnvelopeFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final boolean compare(Name got, String localName, String nameSpaceURI) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase(nameSpaceURI);
    }

    public void setTransferEncoding(String transferEncoding) {
        this._transferEncoding = transferEncoding;
    }

    public void updateMessage() throws SOAPException {
        MimeHeaders headers = this._message.getMimeHeaders();
        headers.setHeader(SOAP_ACTION, EBXML);
        SOAPPart sp = this._message.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPHeader header = envelope.getHeader();
        envelope.getBody();
        sp.setMimeHeader("Content-ID", "<" + this.getMessageId() + ">");
        if (this._acknowledgement != null) {
            SOAPHeaderElement ebHeader = header.addHeaderElement(envelope.createName(EBXML_ACKNOWLEDGEMENT, EB_NS_PREFIX, EB_NS_URI));
            this._acknowledgement.generateSOAP(ebHeader, envelope);
        }
    }

    public void identifyAttachments(String payloadRole, String signatureRole) {
        boolean payloadFound = false;
        boolean signatureFound = false;
        if (this._attachmentInfos.isEmpty()) {
            return;
        }
        for (int i = 0; i < this._attachmentInfos.size(); ++i) {
            boolean schemaLocationsDefined;
            AttachmentInfo info = this._attachmentInfos.get(i);
            boolean bl = schemaLocationsDefined = info.getSchemaLocations() != null && info.getSchemaLocations().length > 0;
            if (info.getRole() != null && (info.getRole().equals(payloadRole) || info.getRole().equals(signatureRole))) {
                if (payloadRole != null && payloadRole.equalsIgnoreCase(info.getRole())) {
                    info.setPayload(true);
                    payloadFound = true;
                    continue;
                }
                if (signatureRole == null || !signatureRole.equalsIgnoreCase(info.getRole())) continue;
                info.setSignature(true);
                signatureFound = true;
                continue;
            }
            if (schemaLocationsDefined) {
                if (payloadFound) continue;
                info.setPayload(true);
                payloadFound = true;
                continue;
            }
            if (!signatureFound && payloadFound) {
                info.setSignature(true);
                signatureFound = true;
                continue;
            }
            if (payloadFound) continue;
            info.setPayload(true);
            payloadFound = true;
        }
    }

    public String getTransferEncoding() {
        return this._transferEncoding;
    }

    public void closeAttachmentStreams() {
        for (int i = 0; i < this._attachmentStreams.size(); ++i) {
            try {
                this._attachmentStreams.get(i).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

