/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimePartDataSource;
import jakarta.mail.internet.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;

public class AttachmentInfo {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private String _role;
    private String[] _schemaLocations;
    private String[] _schemaVersions;
    private String[] _descriptions;
    private String[] _descriptionLanguages;
    private AttachmentPart _attachmentPart;
    private File _localFile;
    private boolean _payload;
    private boolean _signature;

    public String getContentType() {
        return this._attachmentPart.getContentType();
    }

    public String getContentId() {
        return this._attachmentPart.getContentId();
    }

    public ContentDisposition getContentDisposition() {
        try {
            if (this._attachmentPart.getMimeHeader(CONTENT_DISPOSITION) != null && this._attachmentPart.getMimeHeader(CONTENT_DISPOSITION).length > 0) {
                return new ContentDisposition(this._attachmentPart.getMimeHeader(CONTENT_DISPOSITION)[0]);
            }
        }
        catch (ParseException pe) {
            return null;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException, SOAPException {
        return this._attachmentPart.getDataHandler().getInputStream();
    }

    public void writeTo(OutputStream os) throws IOException, SOAPException {
        DataSource source = this._attachmentPart.getDataHandler().getDataSource();
        if (source instanceof MimePartDataSource) {
            MimeBodyPart part = (MimeBodyPart)((MimePartDataSource)source).getMessageContext().getPart();
            try {
                part.writeTo(os);
            }
            catch (MessagingException e) {
                throw new IOException(e.toString());
            }
        } else {
            this._attachmentPart.getDataHandler().writeTo(os);
        }
    }

    public boolean isPayload() {
        return this._payload;
    }

    public boolean isSignature() {
        return this._signature;
    }

    public void setPayload(boolean payload) {
        this._payload = payload;
    }

    public void setSignature(boolean signature) {
        this._signature = signature;
    }

    public AttachmentPart getAttachmentPart() {
        return this._attachmentPart;
    }

    public void setAttachmentPart(AttachmentPart attachmentPart) {
        this._attachmentPart = attachmentPart;
    }

    public String[] getDescriptionLanguages() {
        return this._descriptionLanguages;
    }

    public void setDescriptionLanguages(String[] descriptionLanguages) {
        this._descriptionLanguages = descriptionLanguages;
    }

    public String[] getDescriptions() {
        return this._descriptions;
    }

    public void setDescriptions(String[] descriptions) {
        this._descriptions = descriptions;
    }

    public File getLocalFile() {
        return this._localFile;
    }

    public void setLocalFile(File localFile) {
        this._localFile = localFile;
    }

    public String getRole() {
        return this._role;
    }

    public void setRole(String role) {
        this._role = role;
    }

    public String[] getSchemaLocations() {
        return this._schemaLocations;
    }

    public void setSchemaLocations(String[] schemaLocations) {
        this._schemaLocations = schemaLocations;
    }

    public String[] getSchemaVersions() {
        return this._schemaVersions;
    }

    public void setSchemaVersions(String[] schemaVersions) {
        this._schemaVersions = schemaVersions;
    }
}

