/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.server;

import java.io.IOException;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.StringUtil;

class PontonErrorPageHandler
extends ErrorHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.PontonErrorPageHandler");

    PontonErrorPageHandler() {
    }

    protected void writeErrorHtmlBody(Request request, Writer writer, int code, String message, Throwable cause, boolean showStacks) throws IOException {
        String uri = request.getHttpURI().asString();
        this.writeErrorHtmlMessage(request, writer, code, message, cause, uri);
        if (cause != null) {
            LOGGER.error("Error while processing request: {}, {}", (Object)uri, (Object)message, (Object)cause);
        } else {
            LOGGER.warn("{}: {} {}", (Object)uri, (Object)code, (Object)message);
        }
    }

    protected void writeErrorHtmlMessage(Request request, Writer writer, int code, String message, Throwable cause, String uri) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        String status = Integer.toString(code);
        writer.write(status);
        if (message != null && !message.equals(status)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString((String)message));
        }
        writer.write("</h2>\n");
        writer.write("<table>\n");
        this.writeHtmlRow(writer, "URI", uri);
        this.writeHtmlRow(writer, "STATUS", status);
        this.writeHtmlRow(writer, "MESSAGE", message);
        writer.write("</table>\n");
    }

    private void writeHtmlRow(Writer writer, String tag, Object value) throws IOException {
        writer.write("<tr><th>");
        writer.write(tag);
        writer.write(":</th><td>");
        if (value == null) {
            writer.write("-");
        } else {
            writer.write(StringUtil.sanitizeXmlString((String)value.toString()));
        }
        writer.write("</td></tr>\n");
    }
}

