/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.ldap;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppContactInformation;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.ldap.LdapConnectionPool;
import de.pontonconsulting.xmlpipe.security.ldap.LdapServer;
import java.net.URISyntaxException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class LdapServerQueryService {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + LdapServerQueryService.class.getName()));
    private static final int SAN_URI = 6;
    public static final int SAN_EMAIL = 1;
    public static final String LDAP_CERTIFICATE_STORE = "ldap.certificateStore.";
    private final MessengerConfig messengerConfig;
    private final List<LdapServer> ldapServers;
    private final ExecutorService executorService;
    private final LdapConnectionPool connectionPool;
    private final Profiles profiles;
    private final ReferenceDateTask referenceDateTask;

    public LdapServerQueryService(MessengerConfig messengerConfig, LdapConnectionPool connectionPool, Profiles profiles, ReferenceDateTask referenceDateTask) {
        this.messengerConfig = messengerConfig;
        this.ldapServers = this.readAllLDAPServerConfigurations();
        this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        this.connectionPool = connectionPool;
        this.profiles = profiles;
        this.referenceDateTask = referenceDateTask;
    }

    public void updatePartnerCertificatesFromLDAP(CppPartner partner) {
        if (partner.getPartyIdList().isEmpty()) {
            return;
        }
        PartyId partyId = partner.getPartyIdList().getFirst();
        String partyIdType = partyId.getType();
        if (!(partyIdType.equals("urn:oasis:names:tc:ebcore:partyid-type:unregistered:BDEW") || partyIdType.equals("urn:oasis:names:tc:ebcore:partyid-type:iso6523:0088") || partyIdType.equals("urn:oasis:names:tc:ebcore:partyid-type:unregistered:BAHN") || partyIdType.equals("urn:oasis:names:tc:ebcore:partyid-type:unregistered:DVGW"))) {
            return;
        }
        if (!this.certificateUpdateNeeded(partner)) {
            return;
        }
        long start = System.currentTimeMillis();
        String ou = partyId.getValue();
        LOG.debug("looking for certificate of partyId value: {}", (Object)ou);
        HashMap<LdapServer, Future<Collection>> results = new HashMap<LdapServer, Future<Collection>>();
        for (LdapServer ca : this.ldapServers) {
            if (!ca.isEnabled()) continue;
            Future<Collection> result = this.executorService.submit(() -> this.connectionPool.getCertificates(ca, ou));
            results.put(ca, result);
        }
        results.entrySet().forEach(e -> this.addCertificatesToPartner((Map.Entry<LdapServer, Future<Collection<X509Certificate>>>)e, partner, ou));
        if (partner.getAllValidCertificates().isEmpty()) {
            LOG.warn("no valid certificates for {} found", (Object)partner.getDisplayName());
        }
        long end = System.currentTimeMillis();
        LOG.debug("LDAP lookup took {}ms", (Object)(end - start));
    }

    private boolean certificateUpdateNeeded(CppPartner partner) {
        Set<X509Certificate> currentCertificates = partner.getAllValidCertificates();
        if (currentCertificates.isEmpty()) {
            LOG.info("no certificate installed for partner {}, starting query on LDAP servers", (Object)partner.getDisplayName());
            return true;
        }
        for (X509Certificate certificate : currentCertificates) {
            try {
                Date date = new Date(this.referenceDateTask.getReferenceDate().toInstant().plus((long)Integer.parseInt(this.messengerConfig.getProperty("ponton.messenger.certificate.switch.days_before_expiry")), ChronoUnit.DAYS).toEpochMilli());
                certificate.checkValidity(date);
            }
            catch (CertificateException e) {
                LOG.info("certificate of partner {} about to expire, starting query on LDAP servers: {}", (Object)partner.getDisplayName(), (Object)certificate);
                return true;
            }
        }
        return false;
    }

    private void addCertificatesToPartner(Map.Entry<LdapServer, Future<Collection<X509Certificate>>> entry, CppPartner partner, String ou) {
        LdapServer ldapServer = entry.getKey();
        try {
            Collection<X509Certificate> newCertificates = entry.getValue().get(ldapServer.getTimeoutInMilliseconds(), TimeUnit.MILLISECONDS);
            if (!newCertificates.isEmpty()) {
                this.saveCertificatesToPartnerProfile(partner, newCertificates);
                LOG.info("installed {} certificates for ou: {} found on LDAP server: {}", (Object)newCertificates.size(), (Object)ou, (Object)ldapServer.getName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("unexpected exception while searching {}", (Object)ldapServer.getName(), (Object)e);
        }
        catch (TimeoutException e) {
            LOG.warn("no response from LDAP server: {} within {}ms", (Object)ldapServer.getName(), (Object)ldapServer.getTimeoutInMilliseconds());
        }
    }

    private List<LdapServer> readAllLDAPServerConfigurations() {
        int index = 0;
        ArrayList<LdapServer> ldapServerList = new ArrayList<LdapServer>();
        do {
            this.fetchLDAPServerConfiguration(++index).ifPresent(ldapServerList::add);
        } while (ldapServerList.size() == index);
        return ldapServerList;
    }

    private Optional<LdapServer> fetchLDAPServerConfiguration(int index) {
        String enabled = this.messengerConfig.getProperty(LDAP_CERTIFICATE_STORE + index + ".enabled", "true");
        String name = this.messengerConfig.getProperty(LDAP_CERTIFICATE_STORE + index + ".name");
        String url = this.messengerConfig.getProperty(LDAP_CERTIFICATE_STORE + index + ".url");
        String bind = this.messengerConfig.getProperty(LDAP_CERTIFICATE_STORE + index + ".baseDN");
        String timeout = this.messengerConfig.getProperty(LDAP_CERTIFICATE_STORE + index + ".timeout", "5000");
        if (name != null && url != null && bind != null) {
            try {
                LdapServer server = new LdapServer(name, url, bind, Boolean.parseBoolean(enabled), Long.parseLong(timeout));
                LOG.trace("LDAP certificate store {} added", (Object)name);
                return Optional.of(server);
            }
            catch (URISyntaxException e) {
                LOG.warn("LDAP certificate store {} entry has invalid URL. {}", (Object)name, (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    private void saveCertificatesToPartnerProfile(CppPartner partner, Collection<X509Certificate> newCerts) {
        for (X509Certificate certificate : newCerts) {
            try {
                List<String> extendedKeyUsage = certificate.getExtendedKeyUsage();
                String certificateId = partner.addPartnerCertificate(certificate);
                this.updateDefaultCertificate(partner, certificate, certificateId);
                boolean isTLSClientCert = extendedKeyUsage != null && extendedKeyUsage.contains(KeyPurposeId.id_kp_serverAuth.getId());
                if (!isTLSClientCert) continue;
                LdapServerQueryService.checkSubjectAlternativeNamesAndUpdatePartner(partner, certificate);
            }
            catch (CertificateEncodingException | CertificateParsingException e) {
                LOG.error("certificate invalid and cannot be added to partner {} error:{}", (Object)partner.getDisplayName(), (Object)e.getMessage());
            }
            catch (CertificateIdNotFoundException e) {
                LOG.error("could not set certificate as default for partner {} error:{}", (Object)partner.getDisplayName(), (Object)e.getMessage());
            }
        }
        this.profiles.partnerCertificateUpdated(partner);
        try {
            partner.save();
        }
        catch (ProfileStoreAccessException e) {
            LOG.warn("could not store new certificates in partner profile {} {}: {}", (Object)partner.getDisplayName(), (Object)partner.getLocalId(), (Object)e.getMessage());
        }
    }

    private boolean updateDefaultCertificate(CppPartner localPartner, X509Certificate newCertificate, String newCertificateId) throws CertificateIdNotFoundException {
        X509Certificate defaultCertificate;
        boolean[] keyUsageOfDefaultCertificate;
        boolean[] keyUsage = newCertificate.getKeyUsage();
        if (!(keyUsage == null || !keyUsage[2] || localPartner.getDefaultCertRefId() == null || localPartner.getDefaultCertRefId().equals(newCertificateId) || (keyUsageOfDefaultCertificate = (defaultCertificate = localPartner.getX509Certificate(localPartner.getDefaultCertRefId())).getKeyUsage()) != null && keyUsageOfDefaultCertificate[2])) {
            localPartner.setDefaultCertRefId(newCertificateId);
            LOG.info("The certificate with id '{}' set to default for the partner with id '{}'.", (Object)newCertificateId, (Object)localPartner.getLocalId());
            return true;
        }
        return false;
    }

    private static void checkSubjectAlternativeNamesAndUpdatePartner(CppPartner partner, X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
        if (subjectAlternativeNames != null) {
            for (List<?> generalName : subjectAlternativeNames) {
                LdapServerQueryService.setTransportUrlAndContactEmailFromSubjectAlternativeName(partner, generalName);
            }
        }
    }

    private static void setTransportUrlAndContactEmailFromSubjectAlternativeName(CppPartner partner, List<?> generalName) {
        Integer nameType = (Integer)generalName.get(0);
        if (nameType == 6) {
            String as4Url = (String)generalName.get(1);
            partner.setTransportUrl(partner.getTransportIds()[0], as4Url);
        } else if (nameType == 1) {
            String email = (String)generalName.get(1);
            CppContactInformation contactInformation = new CppContactInformation();
            contactInformation.setEmail(email);
            partner.setContactInformation(contactInformation);
        }
    }
}

