/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.ldap;

import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerCertificateData;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.transport.ssl.SSLKeyManager;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.ServerCertificateTrustManager;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class LdapSSLSocketFactory
extends SSLSocketFactory
implements HandshakeCompletedListener {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + LdapSSLSocketFactory.class.getName()));
    public static final String TLSV_1_2 = "TLSv1.2";
    public static final String TLSV_1_3 = "TLSv1.3";
    public static final String TLS_CLIENT_AUTH_OID = "1.3.6.1.5.5.7.3.2";
    private final SSLSocketFactory defaultFactory;
    private final ServerCertificateTrustManager serverCertificateTrustManager;
    private final MessengerConfig messengerConfig;
    private final PartnerProfileDAO partnerProfileDAO;
    private final CertificateUtility certificateUtility;
    private final ReferenceDateTask referenceDateTask;
    private final IPasswordCrypt passwordCrypt;
    private final KeystoreBean keystoreBean;

    public LdapSSLSocketFactory(ServerCertificateTrustManager serverCertificateTrustManager, MessengerConfig messengerConfig, PartnerProfileDAO partnerProfileDAO, CertificateUtility certificateUtility, ReferenceDateTask referenceDateTask, IPasswordCrypt passwordCrypt, KeystoreBean keystoreBean) throws GeneralSecurityException {
        this.serverCertificateTrustManager = serverCertificateTrustManager;
        this.messengerConfig = messengerConfig;
        this.partnerProfileDAO = partnerProfileDAO;
        this.certificateUtility = certificateUtility;
        this.referenceDateTask = referenceDateTask;
        this.passwordCrypt = passwordCrypt;
        this.keystoreBean = keystoreBean;
        this.defaultFactory = this.createDefaultSocketFactory();
    }

    private SSLSocketFactory createDefaultSocketFactory() throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(null, null, null);
        return sslContext.getSocketFactory();
    }

    private SSLSocketFactory createSocketFactory() throws IOException {
        SignCertInfo signCertInfo = this.getTLSCertificateKey();
        if (signCertInfo == null) {
            LOG.warn("no TLS client certificate found. TLS authentication will fail.");
            return this.defaultFactory;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
            KeyManager[] keyManagers = new SSLKeyManager[]{new SSLKeyManager(signCertInfo.getCertificateChain(), signCertInfo.getPrivateKey())};
            sslContext.init(keyManagers, new TrustManager[]{this.serverCertificateTrustManager}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ge) {
            throw new IOException(ge);
        }
    }

    private SignCertInfo getTLSCertificateKey() {
        for (PartnerCertificateData partnerCertificateData : this.partnerProfileDAO.getLocalPartnerCertificateDataByExtendedKeyUsage(ExtendedKeyUsage.CLIENT_AUTH)) {
            try {
                X509Certificate certificate = this.certificateUtility.getX509Certificate(partnerCertificateData.getCertificate());
                String expectedO = this.messengerConfig.getProperty("ponton.messenger.bdew.csr.org", "");
                if (!expectedO.equals(this.getO(certificate))) continue;
                certificate.checkValidity(this.referenceDateTask.getReferenceDate());
                LOG.trace("selected certificate for LDAPS: {}", (Object)certificate.getSubjectX500Principal().getName());
                String password = this.passwordCrypt.decryptPassword(partnerCertificateData.getPrivateKeyPassword());
                PrivateKey privateKey = CryptoUtil.createPrivateKey(password, partnerCertificateData.getEncryptedPrivateKey());
                X509Certificate[] certificateChain = this.keystoreBean.getKeystore().getCertificateChain(certificate);
                return new SignCertInfo(password, privateKey, certificateChain);
            }
            catch (Exception e) {
                LOG.warn("could not fetch certificate error:{}", (Object)e.toString());
            }
        }
        return null;
    }

    private String getO(X509Certificate x509Certificate) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(x509Certificate).getSubject();
        if (x500name.getRDNs(BCStyle.O) == null || x500name.getRDNs(BCStyle.O).length == 0) {
            return null;
        }
        RDN o = x500name.getRDNs(BCStyle.O)[0];
        return IETFUtils.valueToString((ASN1Encodable)o.getFirst().getValue());
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket(host, port));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket());
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket(host, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableTLS(this.createSocketFactory().createSocket(address, port, localAddress, localPort));
    }

    private Socket enableTLS(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledProtocols(new String[]{TLSV_1_2, TLSV_1_3});
            sslSocket.addHandshakeCompletedListener(this);
        }
        return socket;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        String server = null;
        try {
            server = event.getPeerPrincipal().getName();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        LOG.trace("LDAPS {} {} server: {}", (Object)event.getCipherSuite(), (Object)event.getSession().getProtocol(), (Object)server);
    }
}

