/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.certificate;

import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import de.pontonconsulting.xmlpipe.security.ldap.LdapConnectionPool;
import de.pontonconsulting.xmlpipe.security.ldap.LdapServer;
import jakarta.xml.bind.JAXBException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubCAUpdateTask {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.SubCAUpdateTask");
    static final String SUB_CA_CN_CONFIG_KEY = "ldap.certificateStore.%d.cn";
    static final String SUB_CA_ENABLED_CONFIG_KEY = "ldap.certificateStore.%d.enabled";
    private final LdapConnectionPool ldapConnectionPool;
    private final MessengerConfig messengerConfig;
    private final KeystoreBean keystoreBean;
    private final AtomicBoolean isTLSCertInstalled = new AtomicBoolean(false);
    private final ListenerConfig listenerConfig;
    private final PartnerProfileDAO partnerProfileDAO;

    public SubCAUpdateTask(LdapConnectionPool ldapConnectionPool, MessengerConfig messengerConfig, KeystoreBean keystoreBean, ListenerConfig listenerConfig, PartnerProfileDAO partnerProfileDAO) {
        this.ldapConnectionPool = ldapConnectionPool;
        this.messengerConfig = messengerConfig;
        this.keystoreBean = keystoreBean;
        this.listenerConfig = listenerConfig;
        this.partnerProfileDAO = partnerProfileDAO;
    }

    public boolean isEnabled() {
        String rootLdapUrl = this.messengerConfig.getProperty("ldap.rootCA.url");
        String rootLdapBaseDN = this.messengerConfig.getProperty("ldap.rootCA.baseDN");
        List<String> subCANames = this.getSubCANames();
        return this.isEnabled(rootLdapUrl, rootLdapBaseDN, subCANames);
    }

    private boolean isEnabled(String rootLdapUrl, String rootLdapBaseDN, List<String> subCANames) {
        if (Objects.isNull(rootLdapUrl)) {
            LOG.trace("No Root-CA LDAP url configured");
            return false;
        }
        if (Objects.isNull(rootLdapBaseDN)) {
            LOG.trace("No Root-CA LDAP BaseDN configured");
            return false;
        }
        if (subCANames.isEmpty()) {
            LOG.trace("No SubCA-CNs configured [{}]", (Object)SUB_CA_CN_CONFIG_KEY);
            return false;
        }
        if (!this.isTLSCertInstalled()) {
            LOG.trace("No local partner with TLS certificate installed, which are required for connection to Root-CA LDAP server");
            return false;
        }
        return true;
    }

    public synchronized void updateCertificates() {
        List<String> subCANames;
        String rootLdapBaseDN;
        String rootLdapUrl = this.messengerConfig.getProperty("ldap.rootCA.url");
        if (!this.isEnabled(rootLdapUrl, rootLdapBaseDN = this.messengerConfig.getProperty("ldap.rootCA.baseDN"), subCANames = this.getSubCANames())) {
            return;
        }
        try {
            boolean installOnListener = this.installCertificatesOnListenerToo();
            LOG.info("Start update of SubCA certificates from {}/{} {}", (Object)rootLdapUrl, (Object)rootLdapBaseDN, (Object)(installOnListener ? "(with ListenerUpdate)" : ""));
            LdapServer ldapServer = new LdapServer("Root-CA", rootLdapUrl, rootLdapBaseDN, true, 30000L);
            for (String subCAName : subCANames) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Collection<X509Certificate> subCACerts = this.ldapConnectionPool.getCertificates(ldapServer, "EnergyCA", subCAName);
                if (subCACerts.isEmpty()) {
                    LOG.warn("Found 0 certificates for SubCA '{}' to install", (Object)subCAName);
                    continue;
                }
                LOG.info("Found {} certificates for SubCA '{}' to install", (Object)subCACerts.size(), (Object)subCAName);
                subCACerts.stream().takeWhile(cert -> !Thread.currentThread().isInterrupted()).forEach(cert -> this.importCaCertificate((X509Certificate)cert, subCAName, installOnListener));
            }
        }
        catch (JAXBException | URISyntaxException e) {
            LOG.error(String.format("Can't retrieve SubCA's certs from Root-CA [url=%s / baseDN=%s] due to a %s: %s", rootLdapUrl, rootLdapBaseDN, e.getClass().getSimpleName(), e.getMessage()), e);
        }
    }

    private List<String> getSubCANames() {
        ArrayList<String> subCANames = new ArrayList<String>();
        for (int i = 1; i < 100; ++i) {
            String subCAName = this.messengerConfig.getProperty(SUB_CA_CN_CONFIG_KEY.formatted(i));
            if (!Objects.nonNull(subCAName)) continue;
            subCANames.add(subCAName);
        }
        return subCANames;
    }

    private void importCaCertificate(X509Certificate x509Certificate, String subCAName, boolean installOnListener) {
        try {
            PontonKeystore keystore = this.keystoreBean.getKeystore();
            String keyStoreKey = keystore.addNewCA(x509Certificate);
            LOG.info("Successfully imported certificate for SubCA '{}': {}", (Object)subCAName, (Object)keyStoreKey);
        }
        catch (GeneralSecurityException e) {
            LOG.error(String.format("Can't import ca certificate for SubCA '%s': %s %s", subCAName, e.getMessage(), x509Certificate.getIssuerX500Principal().toString()), (Throwable)(LOG.isDebugEnabled() ? e : null));
        }
        if (installOnListener) {
            try {
                Certificate subCACertificate = new Certificate(x509Certificate.getEncoded());
                this.listenerConfig.installClientCACertificate(subCACertificate);
                LOG.info("Successfully installed certificate for SubCA '{}' on listener ", (Object)subCAName);
            }
            catch (ListenerConfigException | CertificateEncodingException e) {
                LOG.error(String.format("Can't install certificate for SubCA '%s' on listener: %s", subCAName, e.getMessage()), (Throwable)(LOG.isDebugEnabled() ? e : null));
            }
        }
    }

    private boolean isTLSCertInstalled() {
        if (this.isTLSCertInstalled.get()) {
            return true;
        }
        if (this.partnerWithTLSCertificateKeyInstalled()) {
            this.isTLSCertInstalled.set(true);
            return true;
        }
        return false;
    }

    private boolean partnerWithTLSCertificateKeyInstalled() {
        return !this.partnerProfileDAO.getLocalPartnerCertificateDataByExtendedKeyUsage(ExtendedKeyUsage.CLIENT_AUTH).isEmpty();
    }

    private boolean installCertificatesOnListenerToo() {
        try {
            return this.listenerConfig.isConnected() && this.listenerConfig.isSynchronizePartnerCertificatesEnabled();
        }
        catch (ListenerConfigException e) {
            LOG.error("Can't check configuration: {}", (Object)e.getMessage());
            return false;
        }
    }
}

