/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;

public class PreAuthenticationChecks
implements UserDetailsChecker {
    public void check(UserDetails user) {
        MessengerUser pontonUserDetails = (MessengerUser)user;
        if (!pontonUserDetails.isAccountNonLocked()) {
            throw new LockedException("User account is locked until " + String.valueOf(pontonUserDetails.getLockedUntil()));
        }
        if (!pontonUserDetails.isEnabled()) {
            throw new DisabledException("User is disabled");
        }
        if (!pontonUserDetails.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired");
        }
    }
}

